//=============================================================================
// File name : POS4.java
//=============================================================================
package com.oh_tec.pos_4;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ActionBar;
import android.os.Bundle;
import android.os.Handler;
import android.util.TypedValue;
import android.content.DialogInterface;
import android.content.pm.ActivityInfo;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.graphics.RectF;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.DashPathEffect;
import android.hardware.usb.UsbConstants;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.view.View;
import android.view.Window;
import android.view.View.OnClickListener;
import android.view.View.OnLongClickListener;
import android.view.Gravity;
import android.view.Display;
import android.view.WindowManager;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.ScaleGestureDetector.SimpleOnScaleGestureListener;
import android.preference.PreferenceManager;

public class POS4 extends Activity implements Runnable{
    // USB関連変数定義 --------------------------------------------------------
    private UsbManager           mUsbManager;
    private UsbDevice            mDevice;
    private UsbDeviceConnection  mConnection;
    private UsbEndpoint          mEndpointOut;
    private UsbEndpoint          mEndpointIn;
    // バッファ、一般変数 -----------------------------------------------------
    private static final int     BUFFER_SIZE = 64;                      // バッファサイズ
    private byte[]               message  = new byte[BUFFER_SIZE];      // メッセージ
    private byte[]               buffer   = new byte[BUFFER_SIZE];      // データ
    private static final int     DataMax  = 520;                        // 520(Data Ram=8Kbyteの半分を使用,data=8byte(4ch*2byte))
    private static final int     DataMaxG = 500;                        // グラフ表示データ数最大
    private static final int     CH_MAX   = 4;                          // 通常CH最大数
    private static final int     MT_MAX   = 2;                          // MT+,MT-
    private int[][]              DataBff  = new int [CH_MAX+MT_MAX][DataMax  +20];  // データバッファ(CH1-CH4,MT+,MT-) 配列max=BlockMax*8
    private int[][]              DmyData  = new int [CH_MAX+MT_MAX][DataMax*2+20];  // ダミーデータバッファ(USB未接続時)
    // 計測設定 ---------------------------------------------------------------
    private int                  Hscl;                      // ScaleH(計測)
    private int                  HsclG;                     // ScaleH(グラフ)
    private int                  ChSel;                     // SelectCH
    private int[]                ChEn      = new int[CH_MAX+MT_MAX];    // EnableCH(0=OFF,1=DC,2=AC)(CH1-CH4,MT+,MT-)
    private int[]                VsclCh    = new int[CH_MAX+MT_MAX];    // ScaleVCH                 (CH1-CH4,MT+,MT-)
    private int[]                BaseCh    = new int[CH_MAX+MT_MAX];    // BaseCH                   (CH1-CH4,MT+,MT-)
    private int[]                BaseChLst = new int[CH_MAX+MT_MAX];    // BaseCH(前回)             (CH1-CH4,MT+,MT-)
    private int                  Mode;                      // Mode(0=Auto,1=Normal,2=Single)
    private int                  RunCnt;                    // Run Control(0=Run,1=Stop)
    private int                  TrgCh;                     // TrgCH  (計測)  (CH1-CH4)
    private int                  TrgChG;                    // TrgCH  (グラフ)(CH1-CH4)
    private int                  TrgMd;                     // TrgMode(計測)  (0=Rise,1=Fall)
    private int                  TrgMdG;                    // TrgMode(グラフ)(0=Rise,1=Fall)
    private int                  TrgPosV;                   // TrgPosV(計測)
    private int                  TrgPosH;                   // TrgPosH(計測)
    private int                  TrgPosVG;                  // TrgPosV(グラフ)
    private int                  TrgPosHG;                  // TrgPosH(グラフ)
    private int                  TrgPosVLst;                // TrgPosV(前回)
    private int                  TrgPosHLst;                // TrgPosH(前回)
    private int                  MathP1;                    // MT+SRC1
    private int                  MathP2;                    // MT+SRC2
    private int                  MathN1;                    // MT-SRC1
    private int                  MathN2;                    // MT-SRC2
    private int                  TrgTimo;                   // TrgTimeout     (単位=秒)
    private long                 TrgTims;                   // TRG測定開始時間(単位=秒)
    private long                 TrgTimd;                   // TrgTimeoutダウンタイマ(単位=秒)
    // 計測変数 ---------------------------------------------------------------
    private int                  TrgFind;                   // TRG検知フラグ(0=Trg'?,1=Trg'd,2=Timeout,3=Trg'?(前回Timeout))
    private int                  TrgTmChgEn;                // TrgTimeout変更(0=OFF, 1=ON)
    // 補正Offset -------------------------------------------------------------
    private int                  AdjOfstBusy;                           // Offset調整中(0=調整終了,1=調整中)
    private int                  AdjOfstDisp;                           // Offset値表示(0=OFF,1=HOST,2=nouse)
    private static final int     HSCL_MAX = 14;                         // Hscl配列の最大値
    private int[][]              OfstCh   = new int[CH_MAX][HSCL_MAX];  // Offset(CH1-CH4,Hscl=14,bit指定)
    private int[]                OfstChA  = new int[CH_MAX];            // Offset(CH1-CH4) Average
    private int[]                OfstChF  = new int[CH_MAX];            // Offset(CH1-CH4) to POS-4(unsigned int for Flash)
    private int[]                OfstChP  = new int[CH_MAX];            // Offset(CH1-CH4) to POS-4(bit指定)
    // 補正Gain ---------------------------------------------------------------
    private static final float   HrdGain  = 1.03596F;           // Hardware Gain(2.896/3.0V)
    private int                  AdjGainBusy;                   // Gain調整中(0=調整終了,1=Gain+調整中,2=Gain-)
    private int                  AdjGainDisp;                   // Gain値表示(0=OFF,1=HOST,2=POS-4 Gain＆Offset)
    private float[]              GainChA  = new float [CH_MAX]; // Gain+(CH1-CH4)
    private float[]              GainChB  = new float [CH_MAX]; // Gain-(CH1-CH4)
    private float[]              GainChAF = new float [CH_MAX]; // Gain+(CH1-CH4) to POS-4(unsigned int for Flash)
    private float[]              GainChBF = new float [CH_MAX]; // Gain-(CH1-CH4) to POS-4(unsigned int for Flash)
    private float[]              GainChAP = new float [CH_MAX]; // Gain+(CH1-CH4) to POS-4(val)
    private float[]              GainChBP = new float [CH_MAX]; // Gain-(CH1-CH4) to POS-4(val)
    // Measure ----------------------------------------------------------------
    private int                  MeasureDisp;         // Measure値表示(0=OFF,1=ON)
    // モニタ -----------------------------------------------------------------
    private static final float   VIEW_HEIGHT = 1280;  // Hifgt(仮想)
    private static final float   VIEW_WIDTH  = 800;   // Width(仮想)
    private float                RealSizeX;           // RealSize Hight
    private float                RealSizeY;           // RealSize Width
    private float                DispSizeX;           // DisplaySize Hight
    private float                DispSizeY;           // DisplaySize Width
    private float                StBarSize;           // StatusBarSize
    private float                ScaleX;              // DisplaySize比率 Hight(仮想に対する実サイズ比率)
    private float                ScaleY;              // DisplaySize比率 Width(仮想に対する実サイズ比率)
    private int                  ScreenRev;           // 画面向き(0=横固定ノーマル, 1=横固定リバース)
    private int                  ActBarShow;          // アクションバーの表示(0=表示OFF, 1=表示ON)
    // グラフ描画 -------------------------------------------------------------
    private int                  GrpZoomH;            // グラフZoom
    private int                  GrpDtStNo;           // グラフ描画開始データ番号
    private int                  GrpDtStNoLst;        // グラフ描画開始データ番号(前回)
    private int                  MesPosX1;            // MesPosX1
    private int                  MesPosX2;            // MesPosX2
    private int                  MesPosY1;            // MesPosY1
    private int                  MesPosY2;            // MesPosY2
    private int                  MesPosY3;            // MesPosY3
    private int                  MesPosY4;            // MesPosY4
    private int                  MesPosX1Lst;         // MesPosX1(前回)
    private int                  MesPosX2Lst;         // MesPosX2(前回)
    private int                  MesPosY1Lst;         // MesPosY1(前回)
    private int                  MesPosY2Lst;         // MesPosY2(前回)
    // USB制御 ----------------------------------------------------------------
    private static final Handler handler  = new Handler();
    private static final int     BlockMax = 65;       // ブロック最大数  (65block=DataMax*4ch/1block)
    private int                  BlockCnt;            // ブロックカウンタ(64byte単位(1block=32data(4ch*8))
    private int                  ThFlag;              // スレッドループフラグ
    private int                  UsbCnt;              // USB接続回数
    private int                  State;               // STATE
    private static final int     STT_INI  =  0;       // STATE 初期(USB未接続)
    private static final int     STT_STT  =  1;       // STATE 計測開始
    private static final int     STT_AUT  =  2;       // STATE 計測開始(AUTO)
    private static final int     STT_TRG  =  3;       // STATE 計測開始(TRG)
    private static final int     STT_TRD  =  4;       // STATE TRG検知受信
    private static final int     STT_RXD  =  5;       // STATE データ受信(繰り返し)
    private static final int     STT_AJO  =  6;       // STATE Adjust Offset値取得
    private static final int     STT_GRP  =  7;       // STATE グラフ描画
    private static final int     STT_SVG  =  8;       // STATE Save Gain to POS-4
    private static final int     STT_SVO  =  9;       // STATE Save Offset to POS-4
    private static final int     STT_RXG  = 10;       // STATE Load Gain＆Offset from POS-4
    // クラス変数、定数の宣言 -------------------------------------------------
    private static final int     WC     = LinearLayout.LayoutParams.WRAP_CONTENT;
    private static Button[][]    button = new Button[10][2];
    private static TextView      titl0;
    private static TextView      titl1;
    private static TextView      text0;
    private static TextView      mess1;
    private static TextView      mess2;
    private static TextView      mess3;
    private static TextView      mess4;
    private static MyView        graph;
    // USB control commands ---------------------------------------------------
    private static final int     CMD_AUT = 0x31;  // 計測   開始要請(AUTO)
    private static final int     CMD_TRG = 0x32;  // 計測   開始要請(TRG)
    private static final int     CMD_TRD = 0x33;  // TRG検知送信要請
    private static final int     CMD_RXD = 0x34;  // データ 送信要請
    private static final int     CMD_SVG = 0x35;  // Gain   保存要請
    private static final int     CMD_SVO = 0x36;  // Offset 保存要請
    private static final int     CMD_RXG = 0x37;  // Gain＆Offset送信要請
    // タッチイベント ---------------------------------------------------------
    private int                  TouchGuide;      // TouchGuide
                                                  // 0=noView, 1=SclaeH, 2=BaseCH1, 3=BaseCH2, 4=BaseCH3, 5=BaseCH4,6=BaseMT+, 7=BaseMT-,
                                                  // 8=TrgV, 9=TrgH, 10=MesX1,11=MesX2,12=MesY1,13=MesY2,14=Zoom
    private float                TouchDwX;        // TouchDownX
    private float                TouchDwY;        // TouchDownY
    private float                TouchUpX;        // TouchUpX
    private float                TouchUpY;        // TouchUpY
    private float                TouchMvX;        // TouchMoveX
    private float                TouchMvY;        // TouchMoveY
    private int                  MathSel;         // MT選択(0=CH, 1=MT)
    private int                  DrgSel;          // DragMode(0=Base/TRG,2=MeasXY)
    private int                  DrgMvSclH;       // Drag値ScaleH
    private int                  DrgMvTrgV;       // Drag値TrgPosV
    private int                  DrgMvTrgH;       // Drag値TrgPosH
    private int                  DrgMvMsX1;       // Drag値MesX1
    private int                  DrgMvMsX2;       // Drag値MesX2
    private int                  DrgMvMsY1;       // Drag値MesY1
    private int                  DrgMvMsY2;       // Drag値MesY2
    private int[]                DrgMvBsC = new int[CH_MAX+MT_MAX];  // Drag値Base(CH1-CH4,MT+,MT-)
    // スケールジェスチャーイベント -------------------------------------------
    private ScaleGestureDetector gesDetect = null;
    private float                Pinch;           // 1=変化無し, 1より大きい=ピンチアウト, 1より小さい=ピンチイン

    //=========================================================================
    // onCreate
    // アクティビティが初めて作成されるときに呼び出されます。
    //=========================================================================
    @Override
    public void onCreate(Bundle savedInstanceState){
        int  i;
        int  j;

        super.onCreate(savedInstanceState);
        //requestWindowFeature(Window.FEATURE_NO_TITLE);
        //---------------------------------------------------------------------
        // WindowManagerのインスタンス取得
        //---------------------------------------------------------------------
        WindowManager wm = (WindowManager)getSystemService(WINDOW_SERVICE);
        //---------------------------------------------------------------------
        // ディスプレイのインスタンス生成
        //---------------------------------------------------------------------
        Display disp = wm.getDefaultDisplay();
        Point size = new Point();
        // Realサイズを取得 ---------------------------------------------------
        disp.getRealSize(size);             // Realサイズを取得
        RealSizeX = size.x;                 // 参考：Xperia Z3
        RealSizeY = size.y;                 // (x,y)=(1920,1080)
        // Displayサイズを取得 ------------------------------------------------
        disp.getSize(size);                 // Displayサイズを取得
        DispSizeX = size.x;                 // 参考：Xperia Z3
        DispSizeY = size.y;                 // (x,y)=(1794,1080)
        // 比率などの算出 -----------------------------------------------------
        ScaleX    = DispSizeX/VIEW_HEIGHT;  // DisplaySize比率 Hight
        ScaleY    = DispSizeY/VIEW_WIDTH;   // DisplaySize比率 Width
        StBarSize = RealSizeY-DispSizeY;    // StatusBar Size
        //---------------------------------------------------------------------
        // レイアウト定義
        //---------------------------------------------------------------------
        LinearLayout layout = new LinearLayout(this);
        layout.setOrientation(LinearLayout.HORIZONTAL);
        setContentView(layout);
        //---------------------------------------------------------------------
        // サブレイアウト
        //---------------------------------------------------------------------
        LinearLayout layout1 = new LinearLayout(this);
        LinearLayout layout2 = new LinearLayout(this);
        layout1.setOrientation(LinearLayout.VERTICAL);
        layout2.setOrientation(LinearLayout.VERTICAL);
        layout1.setGravity(Gravity.LEFT);
        layout2.setGravity(Gravity.LEFT);
        //---------------------------------------------------------------------
        // タイトル、ボタン、メッセージ
        //---------------------------------------------------------------------
        LinearLayout.LayoutParams params0 = new LinearLayout.LayoutParams((int)(110*ScaleX), WC);               // Title左
        LinearLayout.LayoutParams params1 = new LinearLayout.LayoutParams((int)(110*ScaleX), WC);               // Title右
        LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams((int)(110*ScaleX), (int)(70*ScaleY)); // Button左列
        LinearLayout.LayoutParams params3 = new LinearLayout.LayoutParams((int)(110*ScaleX), (int)(70*ScaleY)); // Button右列
        LinearLayout.LayoutParams params4 = new LinearLayout.LayoutParams((int)(110*ScaleX), WC);               // Message左列
        LinearLayout.LayoutParams params5 = new LinearLayout.LayoutParams((int)(110*ScaleX), WC);               // Message右列
        // レイアウト間隔 -----------------------------------------------------
        params0.setMargins((int)(5*ScaleX),0,0,0);
        params1.setMargins((int)(5*ScaleX),0,0,0);
        params2.setMargins((int)(5*ScaleX),(int)(6*ScaleY),0,0);
        params3.setMargins((int)(5*ScaleX),(int)(6*ScaleY),0,0);
        params4.setMargins((int)(5*ScaleX),(int)(5*ScaleY),0,0);
        params5.setMargins((int)(5*ScaleX),(int)(5*ScaleY),0,0);
        // 文字レイアウト -----------------------------------------------------
        titl0 = new TextView(this);
        titl1 = new TextView(this);
        mess1 = new TextView(this);
        mess2 = new TextView(this);
        mess3 = new TextView(this);
        mess4 = new TextView(this);
        titl0.setLayoutParams(params0);
        titl1.setLayoutParams(params1);
        mess1.setLayoutParams(params4);
        mess2.setLayoutParams(params4);
        mess3.setLayoutParams(params5);
        mess4.setLayoutParams(params5);
        // 文字色 -------------------------------------------------------------
        titl0.setTextColor(Color.MAGENTA);
        titl1.setTextColor(Color.WHITE);
        mess1.setTextColor(Color.WHITE);
        mess2.setTextColor(Color.WHITE);
        mess3.setTextColor(Color.WHITE);
        mess4.setTextColor(Color.WHITE);
        // 文字サイズ ---------------------------------------------------------
        titl0.setTextSize(TypedValue.COMPLEX_UNIT_PX, 37f*ScaleX);
        titl1.setTextSize(TypedValue.COMPLEX_UNIT_PX, 37f*ScaleX);
        mess1.setTextSize(TypedValue.COMPLEX_UNIT_PX, 26f*ScaleX);
        mess2.setTextSize(TypedValue.COMPLEX_UNIT_PX, 26f*ScaleX);
        mess3.setTextSize(TypedValue.COMPLEX_UNIT_PX, 26f*ScaleX);
        mess4.setTextSize(TypedValue.COMPLEX_UNIT_PX, 26f*ScaleX);
        // 文字位置 -----------------------------------------------------------
        titl0.setGravity(Gravity.CENTER);
        titl1.setGravity(Gravity.CENTER);
        mess1.setGravity(Gravity.CENTER);
        mess2.setGravity(Gravity.CENTER);
        mess3.setGravity(Gravity.CENTER);
        mess4.setGravity(Gravity.CENTER);

        //---------------------------------------------------------------------
        // Title表示
        //---------------------------------------------------------------------
        titl0.setText("POS-4");
        layout1.addView(titl0);
        //---------------------------------------------------------------------
        // SubTitle表示
        //---------------------------------------------------------------------
        titl1.setText("");
        layout2.addView(titl1);
        //---------------------------------------------------------------------
        // ボタン表示
        //---------------------------------------------------------------------
        for(i=0; i<8; i++){
            // 1列目 ----------------------------------------------------------
            button[i][0] = new Button(this);
            button[i][0].setBackgroundColor(Color.GRAY);
            button[i][0].setTextSize(TypedValue.COMPLEX_UNIT_PX, 23f*ScaleX);
            button[i][0].setLayoutParams(params2);
            layout1.addView(button[i][0]);
            // 2列目 ----------------------------------------------------------
            button[i][1] = new Button(this);
            button[i][1].setBackgroundColor(Color.GRAY);
            button[i][1].setTextSize(TypedValue.COMPLEX_UNIT_PX, 23f*ScaleX);
            button[i][1].setLayoutParams(params3);
            layout2.addView(button[i][1]);
        }
        // 1列目 --------------------------------------------------------------
        button[0][0].setText("<<H-");
        button[1][0].setText("CH1");
        button[2][0].setText("<<V-");
        button[3][0].setText("<Bs-");
        button[4][0].setText("Auto");
        button[5][0].setText("Trg1");
        button[6][0].setText("<TV-");
        button[7][0].setText("<TH-");
        // 2列目 --------------------------------------------------------------
        button[0][1].setText("H+>>");
        button[1][1].setText("DC");
        button[2][1].setText("V+>>");
        button[3][1].setText("Bs+>");
        button[4][1].setText("Run");
        button[5][1].setText("Rise");
        button[6][1].setText("TV+>");
        button[7][1].setText("TH+>");
        //---------------------------------------------------------------------
        // メッセージ表示
        //---------------------------------------------------------------------
        // 1列目 --------------------------------------------------------------
        mess1.setText("");  // message1
        mess2.setText("");  // message2
        layout1.addView(mess1);
        layout1.addView(mess2);
        // 2列目 --------------------------------------------------------------
        mess3.setText("");  // message3
        mess4.setText("");  // message4
        layout2.addView(mess3);
        layout2.addView(mess4);
        //---------------------------------------------------------------------
        // タイトル、ボタン描画
        //---------------------------------------------------------------------
        layout.addView(layout1);  // 1列目
        layout.addView(layout2);  // 2列目
        //---------------------------------------------------------------------
        // グラフ描画
        //---------------------------------------------------------------------
        graph = new MyView(this);  // グラフ描画
        layout.addView(graph);
        //---------------------------------------------------------------------
        // テキストイベントリスナ生成(Short)
        //---------------------------------------------------------------------
        titl0.setOnClickListener((OnClickListener) new titl0Click());
        titl1.setOnClickListener((OnClickListener) new titl1Click());
        mess1.setOnClickListener((OnClickListener) new mess12Click());
        mess2.setOnClickListener((OnClickListener) new mess12Click());
        mess3.setOnClickListener((OnClickListener) new mess34Click());
        mess4.setOnClickListener((OnClickListener) new mess34Click());
        //---------------------------------------------------------------------
        // テキストイベントリスナ生成(Long)
        //---------------------------------------------------------------------
        titl1.setOnLongClickListener((OnLongClickListener) new titl1ClickLng());
        //---------------------------------------------------------------------
        // ボタンイベントリスナ生成(Short)
        //---------------------------------------------------------------------
        button[0][0].setOnClickListener((OnClickListener) new horiScaleN());   // <<H-
        button[0][1].setOnClickListener((OnClickListener) new horiScaleP());   // H+>>
        //---------------------------------------------------------------------
        button[1][0].setOnClickListener((OnClickListener) new chnSelect());    // CH1
        button[1][1].setOnClickListener((OnClickListener) new chnEnable());    // DC
        //---------------------------------------------------------------------
        button[2][0].setOnClickListener((OnClickListener) new VertSclChn());   // <<V-
        button[2][1].setOnClickListener((OnClickListener) new VertSclChn());   // V+>>
        //---------------------------------------------------------------------
        button[3][0].setOnClickListener((OnClickListener) new BaseChn());      // <Bs-
        button[3][1].setOnClickListener((OnClickListener) new BaseChn());      // Bs+>
        //---------------------------------------------------------------------
        button[4][0].setOnClickListener((OnClickListener) new modeAutNorm());  // Auto
        button[4][1].setOnClickListener((OnClickListener) new runControl());   // Stop
        //---------------------------------------------------------------------
        button[5][0].setOnClickListener((OnClickListener) new trigChn());      // Trg1
        button[5][1].setOnClickListener((OnClickListener) new trigMode());     // Rise
        //---------------------------------------------------------------------
        button[6][0].setOnClickListener((OnClickListener) new trigPosV());     // <TV-
        button[6][1].setOnClickListener((OnClickListener) new trigPosV());     // TV+>
        //---------------------------------------------------------------------
        button[7][0].setOnClickListener((OnClickListener) new trigPosH());     // <TH-
        button[7][1].setOnClickListener((OnClickListener) new trigPosH());     // TH+>
        //---------------------------------------------------------------------
        // ボタンイベントリスナ生成(Long)
        //---------------------------------------------------------------------
        button[1][0].setOnLongClickListener((OnLongClickListener) new chnSelectLng());  // CH1

        //---------------------------------------------------------------------
        // ScaleGestureDetecotorクラスのインスタンス生成
        //---------------------------------------------------------------------
        gesDetect = new ScaleGestureDetector(this, onScaleGestureListener);
        //---------------------------------------------------------------------
        // USBマネージャオブジェクト生成
        //---------------------------------------------------------------------
        mUsbManager = (UsbManager)getSystemService(Context.USB_SERVICE);
        //---------------------------------------------------------------------
        // 初期設定
        //---------------------------------------------------------------------
        Hscl         =  2;      // ScaleH(計測)   = 2
        HsclG        =  2;      // ScaleH(グラフ) = 2
        ChSel        =  0;      // SelectCH = CH1
        //---------------------------------------------------------------------
        ChEn[0]      =  1;      // EnableCH1 = DC
        ChEn[1]      =  1;      // EnableCH2 = DC
        ChEn[2]      =  1;      // EnableCH3 = DC
        ChEn[3]      =  1;      // EnableCH4 = DC
        ChEn[4]      =  0;      // EnableMT+ = OFF
        ChEn[5]      =  0;      // EnableMT- = OFF
        //---------------------------------------------------------------------
        VsclCh[0]    =  5;      // ScaleVCH1  = 5
        VsclCh[1]    =  5;      // ScaleVCH2  = 5
        VsclCh[2]    =  5;      // ScaleVCH3  = 5
        VsclCh[3]    =  5;      // ScaleVCH4  = 5
        VsclCh[4]    =  5;      // ScaleV MT+ = 5
        VsclCh[5]    =  5;      // ScaleV MT- = 5
        //---------------------------------------------------------------------
        BaseCh[0]    =  0;      // BaseCH1  = 0
        BaseCh[1]    =  0;      // BaseCH2  = 0
        BaseCh[2]    =  0;      // BaseCH3  = 0
        BaseCh[3]    =  0;      // BaseCH4  = 0
        BaseCh[4]    =  0;      // Base MT+ = 0
        BaseCh[5]    =  0;      // Base MT- = 0
        BaseChLst[0] =  0;      // BaseCH1 (前回) = 0
        BaseChLst[1] =  0;      // BaseCH2 (前回) = 0
        BaseChLst[2] =  0;      // BaseCH3 (前回) = 0
        BaseChLst[3] =  0;      // BaseCH4 (前回) = 0
        BaseChLst[4] =  0;      // Base MT+(前回) = 0
        BaseChLst[5] =  0;      // Base MT-(前回) = 0
        //---------------------------------------------------------------------
        Mode         =  0;      // Mode(Auto/Normal/Single) = Auto
        RunCnt       =  1;      // Run Control(Run/Stop)    = Stop
        TrgCh        =  0;      // TrgCH  (計測)            = CH1
        TrgChG       =  0;      // TrgCH  (グラフ)          = CH1
        TrgMd        =  0;      // TrgMode(計測)            = Rise
        TrgMdG       =  0;      // TrgMode(グラフ)          = Rise
        TrgPosV      =  0;      // TrgPosV(計測)            = 0
        TrgPosH      =  5;      // TrgPosH(計測)            = 5
        TrgPosVG     =  0;      // TrgPosV(グラフ)          = 0
        TrgPosHG     =  5;      // TrgPosH(グラフ)          = 5
        TrgPosVLst   =  0;      // TrgPosV(前回)            = 0
        TrgPosHLst   =  5;      // TrgPosH(前回)            = 5
        //---------------------------------------------------------------------
        MathP1       =  0;      // MT+SRC1 = CH1
        MathP2       =  1;      // MT+SRC2 = CH2
        MathN1       =  0;      // MT+SRC1 = CH1
        MathN2       =  1;      // MT+SRC2 = CH2
        //---------------------------------------------------------------------
        TrgTimo      =  5;      // TrgTimeout(単位=秒) = 5
        TrgTims      =  0;      // TRG測定開始時間(単位=秒)
        TrgTimd      =  0;      // TrgTimeoutダウンタイマ(単位=秒)
        TrgFind      =  0;      // TRG検知フラグ = Trg'?
        TrgTmChgEn   =  0;      // TrgTimeout変更有効(0=無効, 1=有効)
        //---------------------------------------------------------------------
        State        =  STT_INI;    // STATE = 初期(USB未接続)
        //---------------------------------------------------------------------
        AdjOfstBusy  =  0;      // Offset調整中 = OFF
        AdjOfstDisp  =  0;      // Offset値表示 = OFF
        loadGainOffset(0);      // Offset値を取得
        //---------------------------------------------------------------------
        AdjGainBusy  =  0;      // Gain調整中 = OFF
        AdjGainDisp  =  0;      // Gain値表示 = OFF
        loadGainOffset(1);      // Gain値を取得
        //---------------------------------------------------------------------
        loadScreenRev();        // 画面向きを取得
        //---------------------------------------------------------------------
        ActBarShow   = 0;       // アクションバー表示=OFF
        ActionBar actionBar = getActionBar();
        actionBar.hide();       // アクションバー表示=OFF
        //---------------------------------------------------------------------
        GrpZoomH     =  2;      // グラフZoom
        GrpDtStNo    =  0;      // グラフ描画開始データ番号
        GrpDtStNoLst =  0;      // グラフ描画開始データ番号(前回)
        MesPosX1     =  0;      // MesPosX1 = 0
        MesPosX2     =  0;      // MesPosX2 = 0
        MesPosY1     =  0;      // MesPosY1 = 0
        MesPosY2     =  0;      // MesPosY2 = 0
        MesPosY3     =  0;      // MesPosY3 = 0
        MesPosY4     =  0;      // MesPosY4 = 0
        MesPosX1Lst  =  0;      // MesPosX1(前回) = 0
        MesPosX2Lst  =  0;      // MesPosX2(前回) = 0
        MesPosY1Lst  =  0;      // MesPosY1(前回) = 0
        MesPosY2Lst  =  0;      // MesPosY2(前回) = 0
        //---------------------------------------------------------------------
        ThFlag       =  0;      // スレッドループフラグクリア
        UsbCnt       =  0;      // USB接続回数
        //---------------------------------------------------------------------
        TouchGuide   =  0;      // nonView
        TouchDwX     =  0;      // TouchDownX
        TouchDwY     =  0;      // TouchDownY
        TouchUpX     =  0;      // TouchUpX
        TouchUpY     =  0;      // TouchUpY
        TouchMvX     =  0;      // TouchMoveX
        TouchMvY     =  0;      // TouchMoveY
        MathSel      =  0;      // MT選択=CH
        DrgSel       =  0;      // DragMode(0=Base/TRG)
        DrgMvSclH    =  0;      // Drag値ScaleH
        DrgMvTrgV    =  0;      // Drag値TrgPosV
        DrgMvTrgH    =  0;      // Drag値TrgPosH
        DrgMvMsX1    =  0;      // Drag値MesX1
        DrgMvMsX2    =  0;      // Drag値MesX2
        DrgMvMsY1    =  0;      // Drag値MesY1
        DrgMvMsY2    =  0;      // Drag値MesY2
        DrgMvBsC[0]  =  0;      // Drag値BaseCH1
        DrgMvBsC[1]  =  0;      // Drag値BaseCH2
        DrgMvBsC[2]  =  0;      // Drag値BaseCH3
        DrgMvBsC[3]  =  0;      // Drag値BaseCH4
        DrgMvBsC[4]  =  0;      // Drag値BaseMT+
        DrgMvBsC[5]  =  0;      // Drag値BaseMT-
        //---------------------------------------------------------------------
        Pinch        =  1;      // scale=1:変化無し
        //---------------------------------------------------------------------
        // データバッファクリア
        //---------------------------------------------------------------------
        for(i=0; i<CH_MAX+MT_MAX ;i++){
            for(j=0; j<=DataMax ;j++){
                DataBff[i][j] = 0;
            }
        }
        //---------------------------------------------------------------------
        // USB未接続時(ダミーデータ) Sine波 *0.72=360度/500データ
        //---------------------------------------------------------------------
        for(i=0; i<=DataMax*2; i++){
            DmyData[0][i] = (int)((Math.sin(Math.toRadians((float )(i   ))*0.72*4))*1.405F*1000);
            DmyData[1][i] = (int)((Math.sin(Math.toRadians((float )(i-30))*0.72*4))*1.405F*1000);
            DmyData[2][i] = (int)((Math.sin(Math.toRadians((float )(i-60))*0.72*4))*1.405F*1000);
            DmyData[3][i] = (int)((Math.sin(Math.toRadians((float )(i-90))*0.72*4))*1.405F*1000);
        }
    }

    //=========================================================================
    // メニュー作成
    //=========================================================================
    @Override
    public boolean onCreateOptionsMenu(Menu menu){
        getMenuInflater().inflate(R.menu.option, menu);
        return true;
    }

    //=========================================================================
    // メニューアイテム選択イベント
    //=========================================================================
    @Override
    public boolean onOptionsItemSelected(MenuItem item){
        int i;
        int j;

        // 確認ダイアログの生成 -----------------------------------------------
        AlertDialog.Builder alertDlg = new AlertDialog.Builder(this);
        alertDlg.setTitle("Confirmation");
        alertDlg.setMessage("Do you want to save it?");

        // メニューアイテム ---------------------------------------------------
        switch(item.getItemId()){
            //-----------------------------------------------------------------
            // Display Measurement
            //-----------------------------------------------------------------
            case R.id.setting1:
                if(MeasureDisp==0){
                    MeasureDisp = 1;  // Measure値表示=ON
                    AdjOfstDisp = 0;  // Offset値表示=OFF
                }
                else{
                    MeasureDisp = 0;  // Measure値表示=OFF
                }
                graph.invalidate();   // グラフ描画
                break;
            //-----------------------------------------------------------------
            // Load Setting
            //-----------------------------------------------------------------
            case R.id.setting2:
                loadMeasureSetting();  // 計測設定を取得
                graph.invalidate();    // グラフ描画
                break;
            //-----------------------------------------------------------------
            // Save Setting
            //-----------------------------------------------------------------
            case R.id.setting3:
                // OK ---------------------------------------------------------
                alertDlg.setNegativeButton("OK", new DialogInterface.OnClickListener(){
                    public void onClick(DialogInterface dialog, int which){
                        // OK ボタンクリック
                        saveMeasureSetting();  // 計測設定を保存
                    }
                });
                // Cancel -----------------------------------------------------
                alertDlg.setPositiveButton("Cancel", new DialogInterface.OnClickListener(){
                    public void onClick(DialogInterface dialog, int which){
                        // Cancel ボタンクリック
                        // 何もしない。
                    }
                });
                alertDlg.create().show();  // 表示
                break;
            //-----------------------------------------------------------------
            // Screen Reverse
            //-----------------------------------------------------------------
            case R.id.setting4:
                if(ScreenRev==0){
                    ScreenRev=1;
                    setRequestedOrientation(ActivityInfo. SCREEN_ORIENTATION_REVERSE_LANDSCAPE);  // 横固定リバース
                }
                else{
                    ScreenRev=0;
                    setRequestedOrientation(ActivityInfo. SCREEN_ORIENTATION_LANDSCAPE);          // 横固定ノーマル
                }
                saveScreenRev();     // 画面向きを保存
                graph.invalidate();  // グラフ描画
                break;
            //-----------------------------------------------------------------
            // Display Gain
            // ※Gain調整中は、常に表示(処理なし)
            //-----------------------------------------------------------------
            case R.id.setting5:
                if(AdjGainBusy==0){
                    if(AdjGainDisp!=1){
                        AdjGainDisp = 1;  // Gain値表示=HOST
                    }
                    else{
                        AdjGainDisp = 0;  // Gain値表示=OFF
                    }
                    graph.invalidate();   // グラフ描画
                }
                break;
            //-----------------------------------------------------------------
            // Display Offset
            //-----------------------------------------------------------------
            case R.id.setting6:
                if(AdjOfstDisp!=1){
                    AdjOfstDisp = 1;  // Offset値表示=HOST
                    MeasureDisp = 0;  // Measure値表示=OFF
                }
                else{
                    AdjOfstDisp = 0;  // Offset値表示=OFF
                }
                graph.invalidate();   // グラフ描画
                break;
            //-----------------------------------------------------------------
            // Display Gain/Offset of POS-4
            //-----------------------------------------------------------------
            case R.id.setting7:
                if(AdjGainDisp!=2){
                    AdjGainDisp = 2;  // Gain値表示=POS-4 Gain＆Offset
                }
                else{
                    AdjGainDisp = 0;  // Gain値表示=OFF
                }
                graph.invalidate();   // グラフ描画
                break;
            //-----------------------------------------------------------------
            // Clear Gain
            //-----------------------------------------------------------------
            case R.id.setting8:
                ClearGainOffset(1);  // Gain値をクリア
                AdjGainDisp = 1;     // Gain値表示=HOST
                graph.invalidate();  // グラフ描画
                break;
            //-----------------------------------------------------------------
            // Clear Offset
            //-----------------------------------------------------------------
            case R.id.setting9:
                ClearGainOffset(0);  // Offset値をクリア
                AdjOfstDisp  = 1;    // Offset値表示=HOST
                MeasureDisp = 0;     // Measure値表示=OFF
                graph.invalidate();  // グラフ描画
                break;
            //-----------------------------------------------------------------
            // Adjust Gain
            //-----------------------------------------------------------------
            case R.id.setting10:
                if(AdjGainBusy==0){
                    AdjGainDisp = 1;      // Gain値表示=HOST
                    AdjGainBusy = 1;      // Gain+調整開始
                    titl1.setText("G+");  // G+表示
                    // ボタン名変更 -------------------------------------------
                    button[6][0].setText("<<G-");  // -0.1
                    button[6][1].setText("G+>>");  // +0.1
                    button[7][0].setText("<G-");   // -0.001
                    button[7][1].setText("G+>");   // +0.001
                }
                else{
                    AdjGainDisp = 0;    // Gain値表示=OFF
                    AdjGainBusy = 0;    // Gain調整終了
                    if(TrgTmChgEn==1){ titl1.setText("T"+TrgTimo+"s"); } // Timeout表示
                    else             { titl1.setText(""); }              // Timeout表示=OFF
                    // ボタン名変更(元に戻す) ---------------------------------
                    button[6][0].setText("<TV-");
                    button[6][1].setText("TV+>");
                    button[7][0].setText("<TH-");
                    button[7][1].setText("TH+>");
                }
                graph.invalidate();   // グラフ描画
                break;
            //-----------------------------------------------------------------
            // Adjust Offset
            //-----------------------------------------------------------------
            case R.id.setting11:
                RunCnt = 0;                    // Run
                button[4][1].setText("Stop");  // ボタン名変更
                OffsetSetting();               // Offset調整用設定
                //-------------------------------------------------------------
                AdjOfstDisp = 0;  // Offset値表示=OFF(調整後にシーケンスの中で表示)
                MeasureDisp = 0;  // Measure値表示=OFF
                AdjOfstBusy = 1;  // Offset調整開始
                break;
            //-----------------------------------------------------------------
            // Save Gain
            //-----------------------------------------------------------------
            case R.id.setting12:
                // OK ---------------------------------------------------------
                alertDlg.setNegativeButton("OK", new DialogInterface.OnClickListener(){
                    public void onClick(DialogInterface dialog, int which){
                        // OK ボタンクリック
                        saveGainOffset(1);  // Gain値を保存
                        AdjGainDisp = 0;    // Gain値表示=OFF
                        AdjGainBusy = 0;    // Gain調整終了
                        // ボタン名変更(元に戻す)
                        button[6][0].setText("<TV-");
                        button[6][1].setText("TV+>");
                        button[7][0].setText("<TH-");
                        button[7][1].setText("TH+>");
                    }
                });
                // Cancel -----------------------------------------------------
                alertDlg.setPositiveButton("Cancel", new DialogInterface.OnClickListener(){
                    public void onClick(DialogInterface dialog, int which){
                        // Cancel ボタンクリック
                        // 何もしない。
                    }
                });
                alertDlg.create().show();  // 表示
                break;
            //-----------------------------------------------------------------
            // Save Offset
            //-----------------------------------------------------------------
            case R.id.setting13:
                // OK ---------------------------------------------------------
                alertDlg.setNegativeButton("OK", new DialogInterface.OnClickListener(){
                    public void onClick(DialogInterface dialog, int which){
                        // OK ボタンクリック
                        saveGainOffset(0);  // Offset値を保存
                        AdjOfstDisp = 0;    // Offset値表示=OFF
                    }
                });
                // Cancel -----------------------------------------------------
                alertDlg.setPositiveButton("Cancel", new DialogInterface.OnClickListener(){
                    public void onClick(DialogInterface dialog, int which){
                        // Cancel ボタンクリック
                        // 何もしない。
                    }
                });
                alertDlg.create().show();  // 表示
                break;
            //-----------------------------------------------------------------
            // Save Gain to POS-4
            //-----------------------------------------------------------------
            case R.id.setting14:
                for(i=0; i<CH_MAX; i++){
                    GainChAF[i] = (GainChA[i]+10)*1000;  // Gain+ unsigned int扱いとするため加算
                    GainChBF[i] = (GainChB[i]+10)*1000;  // Gain- unsigned int扱いとするため加算
                }
                // 注意メッセージ ---------------------------------------------
                alertDlg.setIcon(R.drawable.error);                         // 進入禁止ICON
                alertDlg.setTitle("Attention!");                            // Attention!
                alertDlg.setMessage("Do you want to save Gain to POS-4?");  // Message
                // OK ---------------------------------------------------------
                alertDlg.setNegativeButton("OK", new DialogInterface.OnClickListener(){
                    public void onClick(DialogInterface dialog, int which){
                        // OK ボタンクリック
                        State = STT_SVG;  // STATE = Save Gain to POS-4
                    }
                });
                // Cancel -----------------------------------------------------
                alertDlg.setPositiveButton("Cancel", new DialogInterface.OnClickListener(){
                    public void onClick(DialogInterface dialog, int which){
                        // Cancel ボタンクリック
                        // 何もしない。
                    }
                });
                alertDlg.create().show();  // 表示
                break;
            //-----------------------------------------------------------------
            // Save Offset to POS-4
            //-----------------------------------------------------------------
            case R.id.setting15:
                for(i=0; i<CH_MAX; i++){
                    OfstChF[i] = OfstChA[i]+200;  // unsigned int扱いとするため加算
                }
                // 注意メッセージ ---------------------------------------------
                alertDlg.setIcon(R.drawable.error);                           // 進入禁止ICON
                alertDlg.setTitle("Attention!");                              // Attention!
                alertDlg.setMessage("Do you want to save Offset to POS-4?");  // Message
                // OK ---------------------------------------------------------
                alertDlg.setNegativeButton("OK", new DialogInterface.OnClickListener(){
                    public void onClick(DialogInterface dialog, int which){
                        // OK ボタンクリック
                        State = STT_SVO;  // STATE = Save Offset to POS-4
                    }
                });
                // Cancel -----------------------------------------------------
                alertDlg.setPositiveButton("Cancel", new DialogInterface.OnClickListener(){
                    public void onClick(DialogInterface dialog, int which){
                        // Cancel ボタンクリック
                        // 何もしない。
                    }
                });
                alertDlg.create().show();  // 表示
                break;
            //-----------------------------------------------------------------
            default:
                break;
        }
        ActBarShow = 0;     // アクションバー表示=OFF
        ActionBar actionBar = getActionBar();
        actionBar.hide();   // アクションバー表示=OFF
        return super.onOptionsItemSelected(item);
    }

    //=========================================================================
    // Offset調整用の設定
    //=========================================================================
    private void OffsetSetting(){
        Hscl      = 0;  // ScaleH(計測) = 0
        //---------------------------------------------------------------------
        ChEn[0]   = 1;  // EnableCH1 = DC
        ChEn[1]   = 1;  // EnableCH2 = DC
        ChEn[2]   = 1;  // EnableCH3 = DC
        ChEn[3]   = 1;  // EnableCH4 = DC
        ChEn[4]   = 0;  // EnableMT+ = OFF
        ChEn[5]   = 0;  // EnableMT- = OFF
        //---------------------------------------------------------------------
        VsclCh[0] = 0;  // ScaleVCH1 = 0
        VsclCh[1] = 0;  // ScaleVCH2 = 0
        VsclCh[2] = 0;  // ScaleVCH3 = 0
        VsclCh[3] = 0;  // ScaleVCH4 = 0
        //---------------------------------------------------------------------
        BaseCh[0] = 0;  // BaseCH1 = 0
        BaseCh[1] = 0;  // BaseCH2 = 0
        BaseCh[2] = 0;  // BaseCH3 = 0
        BaseCh[3] = 0;  // BaseCH4 = 0
        //---------------------------------------------------------------------
        Mode      = 0;  // Mode(Auto/Normal/Single) = Auto
        RunCnt    = 0;  // Run Control(Run/Stop)    = Run
    }

    //=========================================================================
    // GainOffset値を保存
    // 0= offset, 1=gain
    //=========================================================================
    private void saveGainOffset(int gainofst){
        int i;

        // アプリ標準の Preferences を取得する
        SharedPreferences shPref = PreferenceManager.getDefaultSharedPreferences(this);
        // Preferences に書き込むための Editor クラスを取得する
        SharedPreferences.Editor editor = shPref.edit();
        // 書き込むデータを登録する
        switch(gainofst){
            // Offset値を保存 -------------------------------------------------
            case 0:
                for(i=0; i<HSCL_MAX; i++){ editor.putInt("OfstCh1"+i, OfstCh[0][i]); }  // CH1
                for(i=0; i<HSCL_MAX; i++){ editor.putInt("OfstCh2"+i, OfstCh[1][i]); }  // CH2
                for(i=0; i<HSCL_MAX; i++){ editor.putInt("OfstCh3"+i, OfstCh[2][i]); }  // CH3
                for(i=0; i<HSCL_MAX; i++){ editor.putInt("OfstCh4"+i, OfstCh[3][i]); }  // CH4
                break;
            // Gain値を保存 ---------------------------------------------------
            case 1:
                editor.putFloat("GainChA1", (float)GainChA[0]);  // CH1+
                editor.putFloat("GainChA2", (float)GainChA[1]);  // CH2+
                editor.putFloat("GainChA3", (float)GainChA[2]);  // CH3+
                editor.putFloat("GainChA4", (float)GainChA[3]);  // CH4+
                editor.putFloat("GainChB1", (float)GainChB[0]);  // CH1-
                editor.putFloat("GainChB2", (float)GainChB[1]);  // CH2-
                editor.putFloat("GainChB3", (float)GainChB[2]);  // CH3-
                editor.putFloat("GainChB4", (float)GainChB[3]);  // CH4-
                break;
            default:
                break;
        }
        // 書き込みを確定する
        editor.commit();
    }

    //=========================================================================
    // GainOffset値を取得
    // 0= offset, 1=gain
    //=========================================================================
    private void loadGainOffset(int gainofst){
        int i;

        // アプリ標準の Preferences を取得する
        SharedPreferences shPref = PreferenceManager.getDefaultSharedPreferences(this);
        switch(gainofst){
            // Offset値を取得 -------------------------------------------------
            case 0:
                // データを読み込む(初期起動にてデータが無い場合は、0とする)
                for(i=0; i<HSCL_MAX; i++){ OfstCh[0][i] = shPref.getInt("OfstCh1"+i, 0); }  // CH1
                for(i=0; i<HSCL_MAX; i++){ OfstCh[1][i] = shPref.getInt("OfstCh2"+i, 0); }  // CH2
                for(i=0; i<HSCL_MAX; i++){ OfstCh[2][i] = shPref.getInt("OfstCh3"+i, 0); }  // CH3
                for(i=0; i<HSCL_MAX; i++){ OfstCh[3][i] = shPref.getInt("OfstCh4"+i, 0); }  // CH4
                break;
            // Gain値を取得 ---------------------------------------------------
            case 1:
                // データを読み込む(初期起動にてデータが無い場合は、1とする)
                GainChA[0] = shPref.getFloat("GainChA1", 1);  // CH1+
                GainChA[1] = shPref.getFloat("GainChA2", 1);  // CH2+
                GainChA[2] = shPref.getFloat("GainChA3", 1);  // CH3+
                GainChA[3] = shPref.getFloat("GainChA4", 1);  // CH4+
                GainChB[0] = shPref.getFloat("GainChB1", 1);  // CH1-
                GainChB[1] = shPref.getFloat("GainChB2", 1);  // CH2-
                GainChB[2] = shPref.getFloat("GainChB3", 1);  // CH3-
                GainChB[3] = shPref.getFloat("GainChB4", 1);  // CH4-
                break;
            default:
                break;
        }
    }
    //=========================================================================
    // GainOffset値をクリア
    // 0= offset, 1=gain
    //=========================================================================
    private void ClearGainOffset(int gainofst){
        int i;

        switch(gainofst){
            // Offset値をクリア -----------------------------------------------
            case 0:
                for(i=0; i<HSCL_MAX; i++){ OfstCh[0][i] = 0; }  // CH1
                for(i=0; i<HSCL_MAX; i++){ OfstCh[1][i] = 0; }  // CH2
                for(i=0; i<HSCL_MAX; i++){ OfstCh[2][i] = 0; }  // CH3
                for(i=0; i<HSCL_MAX; i++){ OfstCh[3][i] = 0; }  // CH4
                break;
            // Gain値をクリア -------------------------------------------------
            case 1:
                for(i=0; i<CH_MAX; i++){ GainChA[i] = 1; } // Gain+
                for(i=0; i<CH_MAX; i++){ GainChB[i] = 1; } // Gain-
                break;
            default:
                break;
        }
    }

    //=========================================================================
    // 画面向きを保存
    //=========================================================================
    private void saveScreenRev(){
        // アプリ標準の Preferences を取得する
        SharedPreferences shPref = PreferenceManager.getDefaultSharedPreferences(this);
        // Preferences に書き込むための Editor クラスを取得する
        SharedPreferences.Editor editor = shPref.edit();
        // 書き込むデータを登録する
        editor.putInt("ScreenRev", ScreenRev);
        // 書き込みを確定する
        editor.commit();
    }
    //=========================================================================
    // 画面向きを取得
    //=========================================================================
    private void loadScreenRev(){
        // アプリ標準の Preferences を取得する
        SharedPreferences shPref = PreferenceManager.getDefaultSharedPreferences(this);
        // データを読み込む(初期起動にてデータが無い場合は、0とする)
        ScreenRev = shPref.getInt("ScreenRev", 0);
        // 画面向きを変更 -----------------------------------------------------
        if(ScreenRev==0){
            setRequestedOrientation(ActivityInfo. SCREEN_ORIENTATION_LANDSCAPE);          // 横固定ノーマル
        }
        else{
            setRequestedOrientation(ActivityInfo. SCREEN_ORIENTATION_REVERSE_LANDSCAPE);  // 横固定リバース
        }
    }

    //=========================================================================
    // 計測設定を保存
    //=========================================================================
    private void saveMeasureSetting(){
        // アプリ標準の Preferences を取得する
        SharedPreferences shPref = PreferenceManager.getDefaultSharedPreferences(this);
        // Preferences に書き込むための Editor クラスを取得する
        SharedPreferences.Editor editor = shPref.edit();
        // 書き込むデータを登録する
        editor.putInt("Hscl"      , Hscl);          // ScaleH(計測)
        editor.putInt("ChEn1"     , ChEn[0]);       // EnableCH1
        editor.putInt("ChEn2"     , ChEn[1]);       // EnableCH2
        editor.putInt("ChEn3"     , ChEn[2]);       // EnableCH3
        editor.putInt("ChEn4"     , ChEn[3]);       // EnableCH4
        editor.putInt("ChEn5"     , ChEn[4]);       // EnableMT+
        editor.putInt("ChEn6"     , ChEn[5]);       // EnableMT-
        editor.putInt("VsclCh1"   , VsclCh[0]);     // ScaleVCH1
        editor.putInt("VsclCh2"   , VsclCh[1]);     // ScaleVCH2
        editor.putInt("VsclCh3"   , VsclCh[2]);     // ScaleVCH3
        editor.putInt("VsclCh4"   , VsclCh[3]);     // ScaleVCH4
        editor.putInt("VsclCh5"   , VsclCh[4]);     // ScaleVMT+
        editor.putInt("VsclCh6"   , VsclCh[5]);     // ScaleVMT-
        editor.putInt("BaseChLst1", BaseChLst[0]);  // BaseCH1
        editor.putInt("BaseChLst2", BaseChLst[1]);  // BaseCH2
        editor.putInt("BaseChLst3", BaseChLst[2]);  // BaseCH3
        editor.putInt("BaseChLst4", BaseChLst[3]);  // BaseCH4
        editor.putInt("BaseChLst5", BaseChLst[4]);  // BaseMT+
        editor.putInt("BaseChLst6", BaseChLst[5]);  // BaseMT-
        editor.putInt("Mode"      , Mode);          // Mode
        editor.putInt("TrgCh"     , TrgCh);         // TrgCH
        editor.putInt("TrgMd"     , TrgMd);         // TrgMode
        editor.putInt("MathP1"    , MathP1);        // MT+SRC1
        editor.putInt("MathP2"    , MathP2);        // MT+SRC2
        editor.putInt("MathN1"    , MathN1);        // MT-SRC1
        editor.putInt("MathN2"    , MathN2);        // MT-SRC2
        editor.putInt("TrgPosVLst", TrgPosVLst);    // TrgPosV
        editor.putInt("TrgPosHLst", TrgPosHLst);    // TrgPosH
        editor.putInt("TrgTimo"   , TrgTimo);       // TrgTimeout
        editor.putInt("GrpZoomH"  , GrpZoomH);      // グラフZoom
        // 書き込みを確定する
        editor.commit();
    }
    //=========================================================================
    // 計測設定を取得
    //=========================================================================
    private void loadMeasureSetting(){
        // アプリ標準の Preferences を取得する
        SharedPreferences shPref = PreferenceManager.getDefaultSharedPreferences(this);
        // データを読み込む(初期起動にてデータが無い場合は、Defaultとする)
        Hscl         = shPref.getInt("Hscl"      , Hscl);          // ScaleH(計測)
        ChEn[0]      = shPref.getInt("ChEn1"     , ChEn[0]);       // EnableCH1
        ChEn[1]      = shPref.getInt("ChEn2"     , ChEn[1]);       // EnableCH2
        ChEn[2]      = shPref.getInt("ChEn3"     , ChEn[2]);       // EnableCH3
        ChEn[3]      = shPref.getInt("ChEn4"     , ChEn[3]);       // EnableCH4
        ChEn[4]      = shPref.getInt("ChEn5"     , ChEn[4]);       // EnableMT+
        ChEn[5]      = shPref.getInt("ChEn6"     , ChEn[5]);       // EnableMT-
        VsclCh[0]    = shPref.getInt("VsclCh1"   , VsclCh[0]);     // ScaleVCH1
        VsclCh[1]    = shPref.getInt("VsclCh2"   , VsclCh[1]);     // ScaleVCH2
        VsclCh[2]    = shPref.getInt("VsclCh3"   , VsclCh[2]);     // ScaleVCH3
        VsclCh[3]    = shPref.getInt("VsclCh4"   , VsclCh[3]);     // ScaleVCH4
        VsclCh[4]    = shPref.getInt("VsclCh5"   , VsclCh[4]);     // ScaleVMT+
        VsclCh[5]    = shPref.getInt("VsclCh6"   , VsclCh[5]);     // ScaleVMT-
        BaseChLst[0] = shPref.getInt("BaseChLst1", BaseChLst[0]);  // BaseCH1
        BaseChLst[1] = shPref.getInt("BaseChLst2", BaseChLst[1]);  // BaseCH2
        BaseChLst[2] = shPref.getInt("BaseChLst3", BaseChLst[2]);  // BaseCH3
        BaseChLst[3] = shPref.getInt("BaseChLst4", BaseChLst[3]);  // BaseCH4
        BaseChLst[4] = shPref.getInt("BaseChLst5", BaseChLst[4]);  // BaseMT+
        BaseChLst[5] = shPref.getInt("BaseChLst6", BaseChLst[5]);  // BaseMT-
        Mode         = shPref.getInt("Mode"      , Mode);          // Mode
        TrgCh        = shPref.getInt("TrgCh"     , TrgCh);         // TrgCH
        TrgMd        = shPref.getInt("TrgMd"     , TrgMd);         // TrgMode
        MathP1       = shPref.getInt("MathP1"    , MathP1);        // MT+SRC1
        MathP2       = shPref.getInt("MathP2"    , MathP2);        // MT+SRC2
        MathN1       = shPref.getInt("MathN1"    , MathN1);        // MT-SRC1
        MathN2       = shPref.getInt("MathN2"    , MathN2);        // MT-SRC2
        TrgPosVLst   = shPref.getInt("TrgPosVLst", TrgPosVLst);    // TrgPosV
        TrgPosHLst   = shPref.getInt("TrgPosHLst", TrgPosHLst);    // TrgPosH
        TrgTimo      = shPref.getInt("TrgTimo"   , TrgTimo);       // TrgTimeout
        GrpZoomH     = shPref.getInt("GrpZoomH"  , GrpZoomH);      // グラフZoom
        //---------------------------------------------------------------------
        // ボタン表示変更
        //---------------------------------------------------------------------
        // SelectCH＆ScaleH ---------------------------------------------------
        if(ChSel<4){
            button[1][0].setText("CH"+String.valueOf(ChSel+1));  // CH_no
            button[0][0].setText("<<H-");                        // <<H-
            button[0][1].setText("H+>>");                        // H+>>
        }
        if(ChSel==4){
            button[1][0].setText("MT+");                          // MT+
            button[0][0].setText("CH"+String.valueOf(MathP1+1));  // CH_no
            button[0][1].setText("CH"+String.valueOf(MathP2+1));  // CH_no
        }
        if(ChSel==5){
            button[1][0].setText("MT-");                          // MT-
            button[0][0].setText("CH"+String.valueOf(MathN1+1));  // CH_no
            button[0][1].setText("CH"+String.valueOf(MathN2+1));  // CH_no
        }
        // EnableCH -----------------------------------------------------------
        if(ChEn[ChSel]==0){ button[1][1].setText("Off"); } // Off
        if(ChEn[ChSel]==1){ button[1][1].setText("DC");  } // DC
        if(ChEn[ChSel]==2){ button[1][1].setText("AC");  } // AC
        // Mode ---------------------------------------------------------------
        if(Mode==0){ button[4][0].setText("Auto"); }       // Auto
        if(Mode==1){ button[4][0].setText("Norm"); }       // Norm
        if(Mode==2){ button[4][0].setText("Sing"); }       // Sing
        // TrgCH＆TrgMode -----------------------------------------------------
        if(TrgTmChgEn==0){
            titl1.setText("");               // Timeout表示=OFF
            // TrgCH ----------------------------------------------------------
            button[5][0].setText("Trg"+String.valueOf(TrgCh+1));  // Trg_no
            // TrgMode --------------------------------------------------------
            if(TrgMd==0){ button[5][1].setText("Rise"); } // Rise
            else        { button[5][1].setText("Fall"); } // Fall
        }
        // Timeout ------------------------------------------------------------
        else{
            titl1.setText("T"+TrgTimo+"s");  // Timeout表示
            button[5][0].setText("<Tm-");    // Timeout-
            button[5][1].setText("Tm+>");    // Timeout+
        }
    }

    //=========================================================================
    // onResume
    // アクティビティがユーザーとの対話を開始する直前に呼び出されます。
    //=========================================================================
    @Override
    public void onResume(){
        super.onResume();
        Intent intent = getIntent();
         String action = intent.getAction();
        UsbDevice device = (UsbDevice)intent.getParcelableExtra(UsbManager.EXTRA_DEVICE);
        if(UsbManager.ACTION_USB_DEVICE_ATTACHED.equals(action)){
            mess1.setText("Launch");  //  アプリケーション起動(Application Launch)
            setDevice(device);
        }
        else if(UsbManager.ACTION_USB_DEVICE_DETACHED.equals(action)){
            if(mDevice != null && mDevice.equals(device)){
                setDevice(null);
                mConnection.close();
                mess1.setText("Exit");  // デバイス デタッチで終了(Exit at detached to the device)
            }
        }
    }

    //=========================================================================
    // onPause
    // システムが別のアクティビティを開始しようとしているときに呼び出されます。
    //=========================================================================
    @Override
    public void onPause(){
        super.onPause();
            ThFlag = 0;  // スレットループフラグクリア
    }

    //=========================================================================
    // onDestroy
    // アクティビティが破棄される前に呼び出されます。
    //=========================================================================
    @Override
    public void onDestroy(){
        super.onDestroy();
    }

    //=========================================================================
    // USBデバイスEnumeration
    //=========================================================================
    private void setDevice(UsbDevice device){
        // デバイスインターフェース検出 ---------------------------------------
        if(device.getInterfaceCount() != 1){
            mess2.setText("notIF");  // インターフェース検出できない(Can not find the interface)
            return;
        }
        UsbInterface intf = device.getInterface(0);
        //---------------------------------------------------------------------
        // エンドポイントの検出
        //---------------------------------------------------------------------
        if(intf.getEndpointCount() < 1){
            mess2.setText("notEP");  // エンドポイント検出できない(Can not find the end-point)
            return;
        }
        mess4.setText("EP=" + intf.getEndpointCount());  // 検出エンドポイント数(Detection number of endpoints = )
        //---------------------------------------------------------------------
        // OUTエンドポイントの確認
        //---------------------------------------------------------------------
        UsbEndpoint epout = intf.getEndpoint(0);
        if(epout.getType() != UsbConstants.USB_ENDPOINT_XFER_BULK){
            mess3.setText("noOBlk");  // OUTエンドポイントがバルクタイプでない(OUT end point is not a bulk type)
            return;
        }
        //---------------------------------------------------------------------
        // INエンドポイントの確認
        //---------------------------------------------------------------------
        UsbEndpoint epin = intf.getEndpoint(1);
        if(epin.getType() != UsbConstants.USB_ENDPOINT_XFER_BULK){
            mess3.setText("noIBlk");  // INエンドポイントがバルクタイプでない(IN end point is not a bulk type)
            return;
        }
        //---------------------------------------------------------------------
        // デバイス定数代入
        //---------------------------------------------------------------------
        mDevice      = device;
        mEndpointOut = epout;
        mEndpointIn  = epin;
        //---------------------------------------------------------------------
        // 接続許可確認
        //---------------------------------------------------------------------
        if(mDevice != null){
            UsbDeviceConnection connection = mUsbManager.openDevice(mDevice);
            if(connection != null && connection.claimInterface(intf, true)){
                mConnection = connection;
                mess2.setText("Success");  // USBデバイス接続成功(USB device connection success)
                ThFlag   = 1;              // スレッドループフラグ
                State    = STT_RXG;        // STATE = Load Gain＆Offset from POS-4
                BlockCnt = 0;              // ブロックカウンタクリア
                UsbCnt  += 1;              // USB接続回数
                Thread thread = new Thread(this);  // USB受信スレッド起動
                thread.start();                    // スレッド開始
                mess4.setText("CT="+UsbCnt);       // USB再接続回数
            }
            else{
                mConnection = null;
                mess2.setText("Failure");  // USBデバイス接続失敗(USB device connection failure)
            }
        }
    }

    //=========================================================================
    // タッチイベント
    //=========================================================================
    @Override
    public boolean onTouchEvent(MotionEvent event){
        float movex;   // 1=変化無し, 1より大きい=スワイプ左, 1より小さい=スワイプ右
        float movey;   // 1=変化無し, 1より大きい=スワイプ下, 1より小さい=スワイプ上
        float oftbx;   // オフセット値X
        float oftby;   // オフセット値Y
        float sx1_10;  // ScaleX( 1/10)
        float sx2_10;  // ScaleX( 2/10)
        float sx3_10;  // ScaleX( 3/10)
        float sx4_10;  // ScaleX( 4/10)
        float sx5_10;  // ScaleX( 5/10)
        float sx6_10;  // ScaleX( 6/10)
        float sx7_10;  // ScaleX( 6/10)
        float sx1_5;   // ScaleX( 8/ 5)
        float sx4_5;   // ScaleX( 4/ 5)
        float sy3_14;  // ScaleY( 3/14)
        float sy5_14;  // ScaleY( 5/14)
        float sy11_14; // ScaleY(11/14)

        oftbx   = 260*ScaleX;  // オフセット値X(ボタン=(5+110)*2,グラフX=30))
        oftby   =  35*ScaleY;  // オフセット値X(グラフY=35)
        sx1_10  = (DispSizeX-oftbx)* 1/10+oftbx;
        sx2_10  = (DispSizeX-oftbx)* 2/10+oftbx;
        sx3_10  = (DispSizeX-oftbx)* 3/10+oftbx;
        sx4_10  = (DispSizeX-oftbx)* 4/10+oftbx;
        sx5_10  = (DispSizeX-oftbx)* 5/10+oftbx;
        sx6_10  = (DispSizeX-oftbx)* 6/10+oftbx;
        sx7_10  = (DispSizeX-oftbx)* 7/10+oftbx;
        sx1_5   = (DispSizeX-oftbx)* 1/ 5+oftbx;
        sx4_5   = (DispSizeX-oftbx)* 4/ 5+oftbx;
        sy3_14  = (DispSizeY-StBarSize-oftby)* 3/14+StBarSize+oftby;
        sy5_14  = (DispSizeY-StBarSize-oftby)* 5/14+StBarSize+oftby;
        sy11_14 = (DispSizeY-StBarSize-oftby)*11/14+StBarSize+oftby;

        switch(event.getAction() & MotionEvent.ACTION_MASK){
        case MotionEvent.ACTION_DOWN:
            TouchDwX = event.getX();
            TouchDwY = event.getY();
            break;
        case MotionEvent.ACTION_MOVE:
            TouchMvX = event.getX()-TouchDwX;
            TouchMvY = event.getY()-TouchDwY;
            // DragScaleH -----------------------------------------------------
            if(TouchDwY>sy11_14)             { DrgMvSclH   = (int)(TouchMvX/ScaleX); TouchGuide=1; }  // DragScaleH
            else if(TouchDwX>sx4_5)          {                                       TouchGuide=14;}  // FlickZoom
            // 上記以外 -------------------------------------------------------
            else{
                // DragBase/DragTrg -------------------------------------------
                if(DrgSel==0){
                    if     (TouchDwY<sy3_14) { DrgMvTrgH   = (int)(TouchMvX/ScaleX); TouchGuide=9; }  // DragTrgH
                    else if(TouchDwX<sx1_10) { DrgMvBsC[0] = (int)(TouchMvY/ScaleY); TouchGuide=2; }  // DragBaseCH1
                    else if(TouchDwX<sx2_10) { DrgMvBsC[1] = (int)(TouchMvY/ScaleY); TouchGuide=3; }  // DragBaseCH2
                    else if(TouchDwX<sx3_10) { DrgMvBsC[2] = (int)(TouchMvY/ScaleY); TouchGuide=4; }  // DragBaseCH3
                    else if(TouchDwX<sx4_10) { DrgMvBsC[3] = (int)(TouchMvY/ScaleY); TouchGuide=5; }  // DragBaseCH4
                    else if(TouchDwX<sx5_10) { DrgMvBsC[4] = (int)(TouchMvY/ScaleY); TouchGuide=6; }  // DragBaseMT+
                    else if(TouchDwX<sx6_10) { DrgMvBsC[5] = (int)(TouchMvY/ScaleY); TouchGuide=7; }  // DragBaseMT-
                    else if(TouchDwX<sx4_5)  { DrgMvTrgV   = (int)(TouchMvY/ScaleY); TouchGuide=8; }  // DragTrgV
                }
                // DragMesXY --------------------------------------------------
                if(DrgSel==1){
                    if     (TouchDwX>sx7_10) { DrgMvMsY2   = (int)(TouchMvY/ScaleY); TouchGuide=13;}  // DragMesY2
                    else if(TouchDwX>sx6_10) { DrgMvMsY1   = (int)(TouchMvY/ScaleY); TouchGuide=12;}  // DragMesY1
                    else if(TouchDwY<sy5_14 ){ DrgMvMsX1   = (int)(TouchMvX/ScaleX); TouchGuide=10;}  // DragMesX1
                    else if(TouchDwY<sy11_14){ DrgMvMsX2   = (int)(TouchMvX/ScaleX); TouchGuide=11;}  // DragMesX2
                }
            }
            graph.invalidate();  // グラフ描画
            break;
        case MotionEvent.ACTION_UP:
            TouchUpX = event.getX();
            TouchUpY = event.getY();
            TouchGuide = 0;  // nonView
            //-----------------------------------------------------------------
            // Drag値クリア
            //-----------------------------------------------------------------
            DrgMvSclH = 0;    // Drag値ScaleH
            DrgMvTrgV = 0;    // Drag値TrgPosV
            DrgMvTrgH = 0;    // Drag値TrgPosH
            DrgMvMsX1 = 0;    // Drag値MesX1
            DrgMvMsX2 = 0;    // Drag値MesX2
            DrgMvMsY1 = 0;    // Drag値MesY1
            DrgMvMsY2 = 0;    // Drag値MesY2
            DrgMvBsC[0] = 0;  // Drag値BaseCH1
            DrgMvBsC[1] = 0;  // Drag値BaseCH2
            DrgMvBsC[2] = 0;  // Drag値BaseCH3
            DrgMvBsC[3] = 0;  // Drag値BaseCH4
            DrgMvBsC[4] = 0;  // Drag値BaseMT+
            DrgMvBsC[5] = 0;  // Drag値BaseMT-
            //-----------------------------------------------------------------
            // グラフ描画
            //-----------------------------------------------------------------
            GrpDtStNoLst = GrpDtStNo;  // グラフ描画開始データ番号(前回)
            TrgPosVLst   = TrgPosV;    // TrgPosV (前回)
            TrgPosHLst   = TrgPosH;    // TrgPosH (前回)
            MesPosX1Lst  = MesPosX1;   // MesPosX1(前回)
            MesPosX2Lst  = MesPosX2;   // MesPosX2(前回)
            MesPosY1Lst  = MesPosY1;   // MesPosY1(前回)
            MesPosY2Lst  = MesPosY2;   // MesPosY2(前回)
            BaseChLst[0] = BaseCh[0];  // BaseCH1 (前回)
            BaseChLst[1] = BaseCh[1];  // BaseCH2 (前回)
            BaseChLst[2] = BaseCh[2];  // BaseCH3 (前回)
            BaseChLst[3] = BaseCh[3];  // BaseCH4 (前回)
            BaseChLst[4] = BaseCh[4];  // BaseMT+ (前回)
            BaseChLst[5] = BaseCh[5];  // BaseMT- (前回)
            //-----------------------------------------------------------------
            // フリック操作
            //-----------------------------------------------------------------
            movex = event.getX()-TouchDwX;
            movey = event.getY()-TouchDwY;
            if(movex> 200){}  // フリック左
            if(movex<-200){}  // フリック右
            // ZoomH ----------------------------------------------------------
            if((TouchDwY<sy11_14)&&(TouchDwX>sx4_5)){
                // ZoomH Out --------------------------------------------------
                if(movey> 200){                            // フリック下
                    if     (GrpZoomH==5){ GrpZoomH = 2; }  // 5倍→2倍
                    else if(GrpZoomH==2){ GrpZoomH = 1; }  // 2倍→1倍
                }
                // ZoomH In ---------------------------------------------------
                if(movey<-200){                            // フリック上
                    if     (GrpZoomH==1){ GrpZoomH = 2; }  // 1倍→2倍
                    else if(GrpZoomH==2){ GrpZoomH = 5; }  // 2倍→5倍
                }
            }
            graph.invalidate();  // グラフ描画
            break;
        case MotionEvent.ACTION_CANCEL:
            break;
        }
        gesDetect.onTouchEvent(event);  // タッチイベントをScaleGestureDetector#onTouchEventメソッドに渡す。
        return true;
    }

    //=========================================================================
    // スケールジェスチャーイベント
    //=========================================================================
    private final SimpleOnScaleGestureListener onScaleGestureListener = new SimpleOnScaleGestureListener(){
        @Override
        public boolean onScale(ScaleGestureDetector detector){
            Pinch = detector.getScaleFactor();
            return super.onScale(detector);
        }
        @Override
        public boolean onScaleBegin(ScaleGestureDetector detector){
            return super.onScaleBegin(detector);
        }
        @Override
        public void onScaleEnd(ScaleGestureDetector detector){
            /*=================================================================
            // 操作性が悪いので削除
            // ZoomH In -------------------------------------------------------
            if(Pinch>1){
                if     (GrpZoomH==1){ GrpZoomH = 2; }  // 1倍→2倍
                else if(GrpZoomH==2){ GrpZoomH = 5; }  // 2倍→5倍
                graph.invalidate();                    // グラフ描画
            }
            // ZoomH Out ------------------------------------------------------
            if(Pinch<1){
                if     (GrpZoomH==5){ GrpZoomH = 2; }  // 5倍→2倍
                else if(GrpZoomH==2){ GrpZoomH = 1; }  // 2倍→1倍
                graph.invalidate();                    // グラフ描画
            }
            //=================================================================*/
            super.onScaleEnd(detector);
        }
    };

    //=========================================================================
    // テキストイベントクラス(Short)
    //=========================================================================
    // titl0
    // メニュー表示
    //=========================================================================
    class titl0Click implements OnClickListener{
        public void onClick(View v){
            ActionBar actionBar = getActionBar();
            if(ActBarShow == 1){
                actionBar.hide();  // アクションバー表示=OFF
                ActBarShow = 0;
            }
            else{
                actionBar.show();  // アクションバー表示
                ActBarShow = 1;
            }
        }
    }
    //=========================================================================
    // titl1
    // Adjust Gain+/Gain-切換
    // TrgTimeout変更
    //=========================================================================
    class titl1Click implements OnClickListener{
        public void onClick(View v){
            if(DrgSel==0){
                // Adjust Gain+切換 -------------------------------------------
                if(AdjGainBusy==1){
                    AdjGainBusy = 2;      // Adjust Gain-
                    titl1.setText("G-");  // G-表示
                }
                // Adjust Gain-切換 -------------------------------------------
                else if(AdjGainBusy==2){
                    AdjGainBusy = 1;      // Adjust Gain+
                    titl1.setText("G+");  // G+表示
                }
                // TrgTimeout変更 ---------------------------------------------
                else{
                    if(TrgTmChgEn==0){
                        TrgTmChgEn = 1;                  // TrgTimeout変更=ON
                        titl1.setText("T"+TrgTimo+"s");  // Timeout表示
                        button[5][0].setText("<Tm-");    // Timeout-
                        button[5][1].setText("Tm+>");    // Timeout+
                    }
                    else{
                        TrgTmChgEn = 0;     // TrgTimeout変更=OFF
                        titl1.setText("");  // Timeout表示=OFF
                        //-----------------------------------------------------
                        // ボタン名称を元に戻す
                        //-----------------------------------------------------
                        button[5][0].setText("Trg"+String.valueOf(TrgCh+1)); // Trg_no
                        if(TrgMd == 0){ button[5][1].setText("Rise"); }      // Rise
                        else          { button[5][1].setText("Fall"); }      // Fall
                    }
                }
            }
        }
    }
    //=========================================================================
    // mess12
    // Page Down
    //=========================================================================
    class mess12Click implements OnClickListener{
        public void onClick(View v){
            // 何もしない。
        }
    }
    //=========================================================================
    // mess34
    // Page Up
    //=========================================================================
    class mess34Click implements OnClickListener{
        public void onClick(View v){
            // 何もしない。
        }
    }
    //=========================================================================
    // テキストイベントクラス(Long)
    //=========================================================================
    // titl1(Long)
    //=========================================================================
    class titl1ClickLng implements OnLongClickListener{
        public boolean onLongClick(View v){
            if((AdjGainBusy==0)&&(TrgTmChgEn==0)){
                // DragMode ---------------------------------------------------
                if(DrgSel==0){
                    DrgSel = 1; titl1.setText("MES");  // DragMesXY
                }
                // DragMode解除 -----------------------------------------------
                else{
                    DrgSel = 0; titl1.setText("");     // 解除
                }
                graph.invalidate();  // グラフ描画
            }
            return true;
        }
    }

    //=========================================================================
    // ボタンイベントクラス(Short)
    //=========================================================================
    // ScaleH "<<H-"
    // MT SRC
    //=========================================================================
    class horiScaleN implements OnClickListener{
        public void onClick(View v){
            //-----------------------------------------------------------------
            // CH1-CH4
            //-----------------------------------------------------------------
            if(ChSel<4){
                Hscl = Hscl - 1;       // DOWN
                if(Hscl<0){ Hscl=0; }  // min処理
            }
            //-----------------------------------------------------------------
            // MT SRC1
            //-----------------------------------------------------------------
            if(ChSel==4){
                MathP1 = MathP1 + 1;       // UP
                if(MathP1>3){ MathP1=0; }  // max処理
                button[0][0].setText("CH"+String.valueOf(MathP1+1));  // CH_no
            }
            if(ChSel==5){
                MathN1 = MathN1 + 1;       // UP
                if(MathN1>3){ MathN1=0; }  // max処理
                button[0][0].setText("CH"+String.valueOf(MathN1+1));  // CH_no
            }
            graph.invalidate();  // グラフ描画
        }
    }
    //=========================================================================
    // ScaleH "H+>>"
    // MT SRC
    //=========================================================================
    class horiScaleP implements OnClickListener{
        public void onClick(View v){
            //-----------------------------------------------------------------
            // CH1-CH4
            //-----------------------------------------------------------------
            if(ChSel<4){
                Hscl = Hscl + 1;         // UP
                if(Hscl>13){ Hscl=13; }  // max処理
            }
            //-----------------------------------------------------------------
            // MT SRC2
            //-----------------------------------------------------------------
            if(ChSel==4){
                MathP2 = MathP2 + 1;       // UP
                if(MathP2>3){ MathP2=0; }  // max処理
                button[0][1].setText("CH"+String.valueOf(MathP2+1));  // CH_no
            }
            if(ChSel==5){
                MathN2 = MathN2 + 1;       // UP
                if(MathN2>3){ MathN2=0; }  // max処理
                button[0][1].setText("CH"+String.valueOf(MathN2+1));  // CH_no
            }
            graph.invalidate();  // グラフ描画
        }
    }
    //=========================================================================
    // SelectCH
    //=========================================================================
    class chnSelect implements OnClickListener{
        public void onClick(View v){
            //-----------------------------------------------------------------
            // CH選択
            //-----------------------------------------------------------------
            if(MathSel==0){
                ChSel = ChSel + 1;       // UP
                if(ChSel>3){ ChSel=0; }  // max処理
                button[1][0].setText("CH"+String.valueOf(ChSel+1));  // CH_no

                // ScaleH 表示の変更 ------------------------------------------
                button[0][0].setText("<<H-");  // ScaleH-
                button[0][1].setText("H+>>");  // ScaleH+
                // EnableCH 表示の変更 ----------------------------------------
                if(ChEn[ChSel]==0){ button[1][1].setText("Off"); }  // Off
                if(ChEn[ChSel]==1){ button[1][1].setText("DC");  }  // DC
                if(ChEn[ChSel]==2){ button[1][1].setText("AC");  }  // AC
            }
            //-----------------------------------------------------------------
            // MT選択
            //-----------------------------------------------------------------
            else{
                if(ChSel==5){
                    ChSel = 4;                    // MT+
                    button[1][0].setText("MT+");  // MT+
                    button[0][0].setText("CH"+String.valueOf(MathP1+1));  // MT_SRC1
                    button[0][1].setText("CH"+String.valueOf(MathP2+1));  // MT_SRC2
                }
                else{
                    ChSel = 5;                    // MT-
                    button[1][0].setText("MT-");  // MT-
                    button[0][0].setText("CH"+String.valueOf(MathN1+1));  // MT_SRC1
                    button[0][1].setText("CH"+String.valueOf(MathN2+1));  // MT_SRC2
                }
                // EnableCH 表示の変更 ----------------------------------------
                if(ChEn[ChSel]==0){ button[1][1].setText("Off"); }  // Off
                else              { button[1][1].setText("On" ); ChEn[ChSel] = 1;}  // On
            }
            graph.invalidate();  // グラフ描画
        }
    }
    //=========================================================================
    // EnableCH(0=OFF,1=DC,2=AC)
    //=========================================================================
    class chnEnable implements OnClickListener{
        public void onClick(View v){
            ChEn[ChSel] = ChEn[ChSel] + 1;  // UP
            //-----------------------------------------------------------------
            // CH1-CH4
            //-----------------------------------------------------------------
            if(ChSel<4){
                if(ChEn[ChSel]>=3){ ChEn[ChSel] = 0; }              // max処理
                if(ChEn[ChSel]==0){ button[1][1].setText("Off"); }  // Off
                if(ChEn[ChSel]==1){ button[1][1].setText("DC");  }  // DC
                if(ChEn[ChSel]==2){ button[1][1].setText("AC");  }  // AC
            }
            //-----------------------------------------------------------------
            // MT
            //-----------------------------------------------------------------
            else{
                if(ChEn[ChSel]>=2){ ChEn[ChSel] = 0; }              // max処理
                if(ChEn[ChSel]==0){ button[1][1].setText("Off"); }  // Off
                else              { button[1][1].setText("On");     // On
                                    ChEn[ChSel] = 1; }              // On
            }
            graph.invalidate();  // グラフ描画
        }
    }
    //=========================================================================
    // ScaleVCH
    //=========================================================================
    class VertSclChn implements OnClickListener{
        public void onClick(View v){
            if(v==button[2][0]){
                VsclCh[ChSel] = VsclCh[ChSel] - 1;         // DOWN
                if(VsclCh[ChSel]<0){ VsclCh[ChSel] = 0; }  // min処理
            }
            if(v==button[2][1]){
                VsclCh[ChSel] = VsclCh[ChSel] + 1;         // UP
                if(VsclCh[ChSel]>7){ VsclCh[ChSel] = 7; }  // max処理
            }
            graph.invalidate();  // グラフ描画
        }
    }
    //=========================================================================
    // BaseCH
    //=========================================================================
    class BaseChn implements OnClickListener{
        public void onClick(View v){
            int dt;

            // 50単位に変更 ---------------------------------------------------
            dt = BaseChLst[ChSel]/50;
            BaseChLst[ChSel] = dt*50;
            // UP/DOWN --------------------------------------------------------
            if(v==button[3][0]){
                BaseChLst[ChSel] = BaseChLst[ChSel] - 50;      // DOWN
                if(BaseCh[ChSel]<-300){ BaseCh[ChSel]=-300; }  // min処理
            }
            if(v==button[3][1]){
                BaseChLst[ChSel] = BaseChLst[ChSel] + 50;      // UP
                if(BaseCh[ChSel]>300){ BaseCh[ChSel]=300; }    // max処理
            }
            graph.invalidate();  // グラフ描画
        }
    }
    //=========================================================================
    // Mode(Auto/Normal/Single)
    // グラフの更新は、Thread内で行う。
    //=========================================================================
    class modeAutNorm implements OnClickListener{
        public void onClick(View v){
            Mode = Mode + 1;        // UP
            if(Mode>=3){ Mode=0; }  // max処理
            //-----------------------------------------------------------------
            // ボタン名の変更
            //-----------------------------------------------------------------
            if(Mode==0){ button[4][0].setText("Auto"); }  // Auto
            if(Mode==1){ button[4][0].setText("Norm"); }  // Norm
            if(Mode==2){ button[4][0].setText("Sing"); }  // Sing
            graph.invalidate();  // グラフ描画
        }
    }
    //=========================================================================
    // Run Control(Run/Stop)
    //=========================================================================
    class runControl implements OnClickListener{
        public void onClick(View v){
            if(RunCnt==1){ RunCnt = 0; button[4][1].setText("Run");  // Run
                if(Mode!=0){
                    if(TrgFind==2){ TrgFind = 3; }  // Trg'?(前回Timeout)
                    else          { TrgFind = 0; }  // Trg'?
                }
            }
            else         { RunCnt = 1; button[4][1].setText("Stop"); }  // Stop
            graph.invalidate();  // グラフ描画
        }
    }
    //=========================================================================
    // TrgCH
    // TrgTimeout-
    //=========================================================================
    class trigChn implements OnClickListener{
        public void onClick(View v){
            //-----------------------------------------------------------------
            // TrgTimeout-
            //-----------------------------------------------------------------
            if(TrgTmChgEn==1){
                TrgTimo = TrgTimo - 5;           // DOWN
                if(TrgTimo<5){ TrgTimo = 2; }    // min処理
                titl1.setText("T"+TrgTimo+"s");  // Timeout表示
            }
            //-----------------------------------------------------------------
            // TrgCH
            //-----------------------------------------------------------------
            else{
                TrgCh = TrgCh + 1;       // UP
                if(TrgCh>3){ TrgCh=0; }  // max処理
                // CH表示 -----------------------------------------------------
                button[5][0].setText("Trg"+String.valueOf(TrgCh+1));  // TRG_no
            }
            graph.invalidate();  // グラフ描画
        }
    }
    //=========================================================================
    // TrgMode
    // TrgTimeout+
    //=========================================================================
    class trigMode implements OnClickListener{
        public void onClick(View v){
            //-----------------------------------------------------------------
            // TrgTimeout-
            //-----------------------------------------------------------------
            if(TrgTmChgEn==1){
                if(TrgTimo<5 ){ TrgTimo = 5; }            // UP=5
                else          { TrgTimo = TrgTimo + 5; }  // UP
                if(TrgTimo>60){ TrgTimo = 60; }           // max処理
                titl1.setText("T"+TrgTimo+"s");           // Timeout表示
            }
            //-----------------------------------------------------------------
            // TrgMode
            //-----------------------------------------------------------------
            else{
                if(TrgMd==1){ TrgMd = 0; button[5][1].setText("Rise"); }  // Rise
                else        { TrgMd = 1; button[5][1].setText("Fall"); }  // Fall
            }
            graph.invalidate();  // グラフ描画
        }
    }
    //=========================================================================
    // TrgPosV
    // Gain調整 +0.01
    //=========================================================================
    class trigPosV implements OnClickListener{
        public void onClick(View v){
            if(v==button[6][0]){
                // TrgPosV ----------------------------------------------------
                if(AdjGainBusy==0){
                    if((Mode!=0)&&(ChEn[TrgCh]!=2)){         // 無効(MODE=Auto,TrgCh=AC)
                        TrgPosVLst = TrgPosVLst - 1;         // DOWN
                        if(TrgPosV<-2040){ TrgPosV=-2040; }  // min処理
                    }
                }
                // Gain+調整 --------------------------------------------------
                if(AdjGainBusy==1){
                    titl1.setText("G+");         // G+表示
                    if(ChEn[ChSel]!=0){          // EnableCH時
                        GainChA[ChSel] -= 0.01;  // DOWN(0.01)
                        if(GainChA[ChSel]<0.5){ GainChA[ChSel]=0.5F; }  // min処理(1/2)
                    }
                }
                // Gain-調整 --------------------------------------------------
                if(AdjGainBusy==2){
                    titl1.setText("G-");         // G-表示
                    if(ChEn[ChSel]!=0){          // EnableCH時
                        GainChB[ChSel] -= 0.01;  // DOWN(0.01)
                        if(GainChB[ChSel]<0.5){ GainChB[ChSel]=0.5F; }  // min処理(1/2)
                    }
                }
            }
            //-----------------------------------------------------------------
            if(v==button[6][1]){
                // TrgPosV ----------------------------------------------------
                if(AdjGainBusy==0){
                    if((Mode!=0)&&(ChEn[TrgCh]!=2)){       // 無効(MODE=Auto,TrgCh=AC)
                        TrgPosVLst = TrgPosVLst + 1;       // UP
                        if(TrgPosV>2040){ TrgPosV=2040; }  // max処理
                    }
                }
                // Gain+調整 --------------------------------------------------
                if(AdjGainBusy==1){
                    titl1.setText("G+");         // G+表示
                    if(ChEn[ChSel]!=0){          // EnableCH時
                        GainChA[ChSel] += 0.01;  // UP(0.01)
                        if(GainChA[ChSel]>2){ GainChA[ChSel]=2; }  // max処理(2倍)
                    }
                }
                // Gain-調整 --------------------------------------------------
                if(AdjGainBusy==2){
                    titl1.setText("G-");         // G-表示
                    if(ChEn[ChSel]!=0){          // EnableCH時
                        GainChB[ChSel] += 0.01;  // UP(0.01)
                        if(GainChB[ChSel]>2){ GainChB[ChSel]=2; }  // max処理(2倍)
                    }
                }
            }
            graph.invalidate();  // グラフ描画
        }
    }
    //=========================================================================
    // TrgPosH
    // Gain調整 +0.001
    //=========================================================================
    class trigPosH implements OnClickListener{
        public void onClick(View v){
            if(v==button[7][0]){
                // TrgPosH ----------------------------------------------------
                if(AdjGainBusy==0){
                    if((Mode!=0)&&(ChEn[TrgCh]!=2)){  // 無効(MODE=Auto,TrgCh=AC)
                        TrgPosHLst = TrgPosHLst - 1;  // DOWN
                        if(TrgPosH<5){ TrgPosH=5; }   // min処理
                    }
                }
                // Gain+調整 --------------------------------------------------
                if(AdjGainBusy==1){
                    if(ChEn[ChSel]!=0){           // EnableCH時
                        GainChA[ChSel] -= 0.001;  // DOWN(0.001)
                        if(GainChA[ChSel]<0.5){ GainChA[ChSel]=0.5F; }  // min処理(1/2)
                    }
                }
                // Gain-調整 --------------------------------------------------
                if(AdjGainBusy==2){
                    if(ChEn[ChSel]!=0){           // EnableCH時
                        GainChB[ChSel] -= 0.001;  // DOWN(0.001)
                        if(GainChB[ChSel]<0.5){ GainChB[ChSel]=0.5F; }  // min処理(1/2)
                    }
                }
            }
            //-----------------------------------------------------------------
            if(v==button[7][1]){
                // TrgPosH ----------------------------------------------------
                if(AdjGainBusy==0){
                    if((Mode!=0)&&(ChEn[TrgCh]!=2)){     // 無効(MODE=Auto,TrgCh=AC)
                        TrgPosHLst = TrgPosHLst + 1;     // UP
                        if(TrgPosH>495){ TrgPosH=495; }  // max処理
                    }
                }
                // Gain+調整 --------------------------------------------------
                if(AdjGainBusy==1){
                    if(ChEn[ChSel]!=0){           // EnableCH時
                        GainChA[ChSel] += 0.001;  // UP(0.001)
                        if(GainChA[ChSel]>2){ GainChA[ChSel]=2; }  // max処理(2倍)
                    }
                }
                // Gain-調整 --------------------------------------------------
                if(AdjGainBusy==2){
                    if(ChEn[ChSel]!=0){           // EnableCH時
                        GainChB[ChSel] += 0.001;  // UP(0.001)
                        if(GainChB[ChSel]>2){ GainChB[ChSel]=2; }  // max処理(2倍)
                    }
                }
            }
            graph.invalidate();  // グラフ描画
        }
    }

    //=========================================================================
    // ボタンイベントクラス(Long)
    //=========================================================================
    // SelectCH(Long)
    // EnableCH(Long)
    //=========================================================================
    class chnSelectLng implements OnLongClickListener{
        public boolean onLongClick(View v){
            //-----------------------------------------------------------------
            // CH選択
            //-----------------------------------------------------------------
            if(MathSel==1){
                MathSel = 0;  // CH選択
                ChSel   = 0;  // CH1
                button[1][0].setText("CH"+String.valueOf(ChSel+1));  // CH_no
                // ScaleH 表示の変更 ------------------------------------------
                button[0][0].setText("<<H-");  // ScaleH-
                button[0][1].setText("H+>>");  // ScaleH+
                // EnableCH 表示の変更 ----------------------------------------
                if(ChEn[ChSel]==0){ button[1][1].setText("Off"); }  // Off
                if(ChEn[ChSel]==1){ button[1][1].setText("DC");  }  // DC
                if(ChEn[ChSel]==2){ button[1][1].setText("AC");  }  // AC
            }
            //-----------------------------------------------------------------
            // MT選択
            //-----------------------------------------------------------------
            else{
                MathSel = 1;  // MT選択
                ChSel   = 4;  // MT+
                button[1][0].setText("MT+");
                button[0][0].setText("CH"+String.valueOf(MathP1+1));  // MT_SRC1
                button[0][1].setText("CH"+String.valueOf(MathP2+1));  // MT_SRC2
                // EnableCH 表示の変更 ----------------------------------------
                if(ChEn[ChSel]==0){ button[1][1].setText("Off"); }                  // Off
                else              { button[1][1].setText("On" ); ChEn[ChSel] = 1;}  // On
            }
            graph.invalidate();  // グラフ描画
            return true;
        }
    }

    //=========================================================================
    // コマンド送信メソッド
    //=========================================================================
    private void sendCommand(int control){
        float  trgGain;
        float  trgGainP;
        float  trgLvl;
        float  dt;

        synchronized (this){
            if(mConnection != null){
                switch(control){
                    case CMD_AUT:
                        message[0] = CMD_AUT;        // 計測開始要請(AUT0)
                        message[1] = (byte) Hscl;    // ScaleH(計測)
                        break;
                    case CMD_TRG:
                        message[0]  = CMD_TRG;       // 計測開始要請(TRG)
                        message[1]  = (byte) Hscl;   // ScaleH(計測)
                        message[2]  = (byte) TrgCh;  // TrgCH
                        message[3]  = (byte) TrgMd;  // TrgMode(0=Rise,1=Fall)
                        //-----------------------------------------------------
                        // TrgLvl(-2047～2048)→(4095～0)
                        //-----------------------------------------------------
                        if(TrgPosV>0){ trgGain = GainChA[TrgCh]*HrdGain; } // Gain+(HOST)
                        else         { trgGain = GainChB[TrgCh]*HrdGain; } // Gain-(HOST)
                        if(TrgPosV>0){ trgGainP= GainChAP[TrgCh]; }        // Gain+(POS-4)
                        else         { trgGainP= GainChBP[TrgCh]; }        // Gain-(POS-4)
                        dt = (TrgPosV-OfstCh[TrgCh][Hscl])/trgGain;        // HOST  Gain＆Offset
                        dt = (dt     -OfstChP[TrgCh])     /trgGainP;       // POS-4 Gain＆Offset
                        // データ=12bit(Straight Binary Code) -----------------
                        dt = dt + 2047;            // データ中心(12bit)
                        dt = 4095 - dt;            // データ反転(12bit)
                        if(dt<0   ){ dt =    0; }  // min処理
                        if(dt>4095){ dt = 4095; }  // max処理
                        trgLvl = (int)dt;          // TRGレベル
                        // TRG Lvl --------------------------------------------
                        message[4]  = (byte)(trgLvl%128);   // TrgLvl LSB
                        message[5]  = (byte)(trgLvl/128);   // TrgLvl MSB
                        // TrgPosH --------------------------------------------
                        message[6]  = (byte)(TrgPosH%128);  // TrgPosH LSB
                        message[7]  = (byte)(TrgPosH/128);  // TrgPosH MSB
                        // TrgTimeout -----------------------------------------
                        message[8] = (byte) TrgTimo;        // TrgTimeout

                        break;
                    case CMD_TRD:
                        message[0] = CMD_TRD;  // TRG検知送信要請
                        break;
                    case CMD_RXD:
                        message[0] = CMD_RXD;  // データ送信要請
                        break;
                    case CMD_SVG:
                        message[0] = CMD_SVG;  // Gain保存要請
                        // Gain+ ----------------------------------------------
                        message[1]  = (byte)(GainChAF[0]%128);  // CH1+ LSB
                        message[2]  = (byte)(GainChAF[0]/128);  // CH1+ MSB
                        message[3]  = (byte)(GainChAF[1]%128);  // CH2+ LSB
                        message[4]  = (byte)(GainChAF[1]/128);  // CH2+ MSB
                        message[5]  = (byte)(GainChAF[2]%128);  // CH3+ LSB
                        message[6]  = (byte)(GainChAF[2]/128);  // CH3+ MSB
                        message[7]  = (byte)(GainChAF[3]%128);  // CH4+ LSB
                        message[8]  = (byte)(GainChAF[3]/128);  // CH4+ MSB
                        // Gain- ----------------------------------------------
                        message[9]  = (byte)(GainChBF[0]%128);  // CH1- LSB
                        message[10] = (byte)(GainChBF[0]/128);  // CH1- MSB
                        message[11] = (byte)(GainChBF[1]%128);  // CH2- LSB
                        message[12] = (byte)(GainChBF[1]/128);  // CH2- MSB
                        message[13] = (byte)(GainChBF[2]%128);  // CH3- LSB
                        message[14] = (byte)(GainChBF[2]/128);  // CH3- MSB
                        message[15] = (byte)(GainChBF[3]%128);  // CH4- LSB
                        message[16] = (byte)(GainChBF[3]/128);  // CH4- MSB
                        break;
                    case CMD_SVO:
                        message[0] = CMD_SVO;                 // Offset保存要請
                        message[1] = (byte)(OfstChF[0]%128);  // CH1 LSB
                        message[2] = (byte)(OfstChF[0]/128);  // CH1 MSB
                        message[3] = (byte)(OfstChF[1]%128);  // CH2 LSB
                        message[4] = (byte)(OfstChF[1]/128);  // CH2 MSB
                        message[5] = (byte)(OfstChF[2]%128);  // CH3 LSB
                        message[6] = (byte)(OfstChF[2]/128);  // CH3 MSB
                        message[7] = (byte)(OfstChF[3]%128);  // CH4 LSB
                        message[8] = (byte)(OfstChF[3]/128);  // CH4 MSB
                        break;
                    case CMD_RXG:
                        message[0] = CMD_RXG;  // Gain＆Offset送信要請
                        break;
                    default:
                        break;
                }
                // エンドポイントでコマンド送信 常に64byte送信
                mConnection.bulkTransfer(mEndpointOut, message, 64, 0);
            }
        }
    }

    //=========================================================================
    // USBデータ受信スレッド 一定周期で繰り返し
    //=========================================================================
    @Override
    public void run(){
        int   result; // 受信データ
        int   ch;     // CH番号
        int   dt;     // データ
        int   dtmax;  // データmax
        int   dtmin;  // データmin
        int   ofst;   // Offset
        int[] tmp = new int[CH_MAX];
        int   i;

        while(ThFlag == 1){
            switch(State){
                //-------------------------------------------------------------
                // 計測開始
                //-------------------------------------------------------------
                case STT_STT :
                    if(RunCnt==0){
                    HsclG    = Hscl;     // ScaleH (グラフ)
                    TrgMdG   = TrgMd;    // TrgMode(グラフ)
                    TrgChG   = TrgCh;    // TrgCH  (グラフ)
                    TrgPosVG = TrgPosV;  // TrgPosV(グラフ)
                    TrgPosHG = TrgPosH;  // TrgPosH(グラフ)
                    if(Mode==0){ State = STT_AUT; }  // STATE = 計測開始(AUTO)
                        else   { State = STT_TRG; }  // STATE = 計測開始(TRG)
                    }
                    break;
                //-------------------------------------------------------------
                // 計測開始(AUTO)
                //-------------------------------------------------------------
                case STT_AUT :
                    sendCommand(CMD_AUT);  // 計測開始要請(AUTO)
                    result = mConnection.bulkTransfer(mEndpointIn, buffer, 64, 0);
                    //---------------------------------------------------------
                    // コマンド受信
                    //---------------------------------------------------------
                    if((result > 0)&&(buffer[0] == 'A')&&(buffer[1] == 'T')){
                        BlockCnt = 0;        // ブロックカウンタクリア
                        State    = STT_RXD;  // STATE = データ受信
                        // メッセージ出力 -------------------------------------
                        handler.post(new Runnable(){
                            public void run(){
                                mess3.setText("Resume");  // 通信再開(Communication Resume)
                            }
                        });
                    }
                    //---------------------------------------------------------
                    // 正常応答でなければデバイスが切り離されたとしてスレッド終了
                    //---------------------------------------------------------
                    else{
                        mConnection.close();
                        ThFlag = 0;  // スレットループフラグクリア
                        // メッセージ出力 -------------------------------------
                        handler.post(new Runnable(){
                            public void run(){
                                mess3.setText("DisCon");  // デバイスが切り離されました(The device has been disconnected)
                            }
                        });
                    }
                    //---------------------------------------------------------
                    // 計測時間待ち(表示更新間隔)
                    //---------------------------------------------------------
                    try{
                        Thread.sleep(100);  // Xperia Z3にて確認
                    }catch(InterruptedException e){ }
                    break;
                //-------------------------------------------------------------
                // 計測開始(TRG)
                //-------------------------------------------------------------
                case STT_TRG :
                    sendCommand(CMD_TRG);  // 計測開始要請(TRG)
                    result = mConnection.bulkTransfer(mEndpointIn, buffer, 64, 0);
                    //---------------------------------------------------------
                    // コマンド受信
                    //---------------------------------------------------------
                    if((result > 0)&&(buffer[0] == 'T')&&(buffer[1] == 'G')){
                        BlockCnt = 0;        // ブロックカウンタクリア
                        State    = STT_TRD;  // STATE = TRG検知受信
                        TrgTims  = System.currentTimeMillis()/1000;  // TRG測定開始時間(秒)
                        // メッセージ出力 -------------------------------------
                        handler.post(new Runnable(){
                            public void run(){
                                mess3.setText("Resume");  // 通信再開(Communication Resume)
                            }
                        });
                    }
                    //---------------------------------------------------------
                    // 正常応答でなければデバイスが切り離されたとしてスレッド終了
                    //---------------------------------------------------------
                    else{
                        mConnection.close();
                        ThFlag = 0;  // スレットループフラグクリア
                        // メッセージ出力 -------------------------------------
                        handler.post(new Runnable(){
                            public void run(){
                                mess3.setText("DisCon");  // デバイスが切り離されました(The device has been disconnected)
                            }
                        });
                    }
                    //---------------------------------------------------------
                    // 計測時間待ち(表示更新間隔)
                    //---------------------------------------------------------
                    try{
                        Thread.sleep(100);  // Xperia Z3にて確認
                    }catch(InterruptedException e){ }
                    break;
                //-------------------------------------------------------------
                // TRG検知受信
                //-------------------------------------------------------------
                case STT_TRD :
                    sendCommand(CMD_TRD);  // TRG検知送信要請
                    result = mConnection.bulkTransfer(mEndpointIn, buffer, 64, 0);
                    //---------------------------------------------------------
                    // TRG検出
                    //---------------------------------------------------------
                    if((result > 0)&&(buffer[0] == 'T')&&(buffer[1] == 'P')){  // TRG検出
                        TrgFind  = 1;               // Trd'd
                        if(Mode==2){ RunCnt = 1; }  // Single時 Stop
                        BlockCnt = 0;               // ブロックカウンタクリア
                        State    = STT_RXD;         // STATE = データ受信
                        // メッセージ出力 -------------------------------------
                        handler.post(new Runnable(){
                            public void run(){
                                mess3.setText("Resume");  // 通信再開(Communication Resume)
                            }
                        });
                    }
                    //---------------------------------------------------------
                    // TrgTimeout
                    //---------------------------------------------------------
                    else if((result > 0)&&(buffer[0] == 'T')&&(buffer[1] == 'N')){  // TrgTimeout
                        TrgFind  = 2;        // TrgTimeout
                        RunCnt   = 1;        // Stop
                        BlockCnt = 0;        // ブロックカウンタクリア
                        State    = STT_RXD;  // STATE = データ受信
                        // メッセージ出力 -------------------------------------
                        handler.post(new Runnable(){
                            public void run(){
                                mess3.setText("Resume");  // 通信再開(Communication Resume)
                            }
                        });
                    }
                    //---------------------------------------------------------
                    // 正常応答でなければデバイスが切り離されたとしてスレッド終了
                    //---------------------------------------------------------
                    else{
                        mConnection.close();
                        ThFlag = 0;  // スレットループフラグクリア
                        // メッセージ出力 -------------------------------------
                        handler.post(new Runnable(){
                            public void run(){
                                mess3.setText("DisCon");  // デバイスが切り離されました(The device has been disconnected)
                            }
                        });
                    }
                    /*=========================================================
                    // 削除
                    // setTextは、処理が重い。
                    // このままでは使用できません。(表示が更新されない。)
                    //---------------------------------------------------------
                    // TrgTimeoutダウンタイマー
                    //---------------------------------------------------------
                    // メッセージ出力 -----------------------------------------
                    handler.post(new Runnable(){
                        @Override
                        public void run(){
                            TrgTimd  = (int)(TrgTimo-(System.currentTimeMillis()/1000-TrgTims));  // TrgTimoutダウンタイマー
                            mess4.setText("T="+TrgTimd+"s");  // メッセージ出力
                        }
                    });
                    =========================================================*/
                    break;
                //-------------------------------------------------------------
                // データ受信(繰り返し)
                //-------------------------------------------------------------
                case STT_RXD :
                    sendCommand(CMD_RXD);  // データ送信要請
                    result = mConnection.bulkTransfer(mEndpointIn, buffer, 64, 0);
                    //---------------------------------------------------------
                    // データ受信(0～4095)→(2048～-2047)
                    //---------------------------------------------------------
                    if(result > 0){
                        // データ受信 -----------------------------------------
                        for(i=0; i<64; i+=2){  // 64byte受信(2byte/data)
                            dt = buffer[i+1]*128 + buffer[i];  // データ加工(MSB+LSB)
                            // データ=12bit(Offset Binary Code) ---------------
                            ch = (i/2)%4;      // CH番号
                            dt = 4095 - dt;    // データ反転(12bit)
                            dt = dt - 2047;    // データ中心(12bit)
                            // POS-4 Gain&Offset ------------------------------
                            if((dt+OfstChP[ch])>0){ DataBff[ch][BlockCnt*8+i/8] = (int)(dt*GainChAP[ch]+OfstChP[ch]); } // POS-4 Gain+＆Offset
                            else                  { DataBff[ch][BlockCnt*8+i/8] = (int)(dt*GainChBP[ch]+OfstChP[ch]); } // POS-4 Gain-＆Offset
                        }
                        BlockCnt++;  // ブロックカウンタUP
                        if(BlockCnt >= BlockMax){
                            BlockCnt = 0;  // ブロックカウンタクリア
                            if(AdjOfstBusy==1){ State = STT_AJO; }  // STATE = Adjust Offset値取得
                            else              { State = STT_GRP; }  // STATE = グラフ描画
                        }
                    }
                    //---------------------------------------------------------
                    // 正常受信できなければスレッド終了
                    //---------------------------------------------------------
                    else{
                        mConnection.close();
                        ThFlag = 0;  // スレッドループフラグクリア
                        // メッセージ出力 -------------------------------------
                        handler.post(new Runnable(){
                            public void run(){
                                mess3.setText("DisCon");  // デバイスが切り離されました(The device has been disconnected)
                            }
                        });
                    }
                    break;
                //-------------------------------------------------------------
                // Adjust Offset値取得
                //-------------------------------------------------------------
                case STT_AJO :
                    //---------------------------------------------------------
                    // Offset値の算出(表示範囲＆前後10データ除く)
                    //---------------------------------------------------------
                    tmp[0] = 0;  // クリアCH1
                    tmp[1] = 0;  // クリアCH2
                    tmp[2] = 0;  // クリアCH3
                    tmp[3] = 0;  // クリアCH4
                    // データを合計 -------------------------------------------
                    for(i=10; i<240; i++){        // 表示範囲＆前後10データ除く
                        tmp[0] += DataBff[0][i];  // CH1
                        tmp[1] += DataBff[1][i];  // CH2
                        tmp[2] += DataBff[2][i];  // CH3
                        tmp[3] += DataBff[3][i];  // CH4
                    }
                    // 平均値算出 ---------------------------------------------
                    OfstCh[0][Hscl] = (tmp[0]/230)*-1;  // CH1
                    OfstCh[1][Hscl] = (tmp[1]/230)*-1;  // CH2
                    OfstCh[2][Hscl] = (tmp[2]/230)*-1;  // CH3
                    OfstCh[3][Hscl] = (tmp[3]/230)*-1;  // CH4
                    // max＆min処理(Offset値が±2Vを越えている場合) -----------
                    // ※2V=±117(±35/12bit)
                    if((OfstCh[0][Hscl]<-117)||(OfstCh[0][Hscl]>117)){ OfstCh[0][Hscl] = 0; }  // CH1
                    if((OfstCh[1][Hscl]<-117)||(OfstCh[1][Hscl]>117)){ OfstCh[1][Hscl] = 0; }  // CH2
                    if((OfstCh[2][Hscl]<-117)||(OfstCh[2][Hscl]>117)){ OfstCh[2][Hscl] = 0; }  // CH3
                    if((OfstCh[3][Hscl]<-117)||(OfstCh[3][Hscl]>117)){ OfstCh[3][Hscl] = 0; }  // CH4
                    // 使用していないレンジは、0とする ------------------------
                    OfstCh[1][0] = 0;  // CH2(Hscl=0)
                    OfstCh[2][0] = 0;  // CH3(Hscl=0)
                    OfstCh[2][1] = 0;  // CH3(Hscl=1)
                    OfstCh[3][0] = 0;  // CH4(Hscl=0)
                    OfstCh[3][1] = 0;  // CH4(Hscl=1)
                    //---------------------------------------------------------
                    // Offset調整終了
                    //---------------------------------------------------------
                    if(Hscl>=13){
                        Hscl        = 2;  // ScaleH(計測)=2(Default)
                        AdjOfstDisp = 1;  // Offset値表示=HOST
                        AdjOfstBusy = 0;  // Offset調整終了
                        RunCnt      = 1;  // Stop
                    }
                    Hscl++;           // ScaleH(計測) UP
                    State = STT_GRP;  // STATE = グラフ描画
                    break;
                //-------------------------------------------------------------
                // グラフ描画
                //-------------------------------------------------------------
                case STT_GRP :
                    handler.post(new Runnable(){
                        public void run(){
                            graph.invalidate();  // グラフ描画
                        }
                    });
                    State = STT_STT;  // STATE = 計測開始
                    break;
                //-------------------------------------------------------------
                // Gain保存
                //-------------------------------------------------------------
                case STT_SVG :
                    sendCommand(CMD_SVG);  // Gain保存要請
                    result = mConnection.bulkTransfer(mEndpointIn, buffer, 64, 0);
                    //---------------------------------------------------------
                    // コマンド受信
                    //---------------------------------------------------------
                    if((result > 0)&&(buffer[0] == 'S')&&(buffer[1] == 'G')){
                        State = STT_STT;  // STATE = 計測開始
                        // メッセージ出力 -------------------------------------
                        handler.post(new Runnable(){
                            public void run(){
                                mess3.setText("Resume");  // 通信再開(Communication Resume)
                            }
                        });
                    }
                    //---------------------------------------------------------
                    // 正常応答でなければデバイスが切り離されたとしてスレッド終了
                    //---------------------------------------------------------
                    else{
                        mConnection.close();
                        ThFlag = 0;  // スレットループフラグクリア
                        // メッセージ出力 -------------------------------------
                        handler.post(new Runnable(){
                            public void run(){
                                mess3.setText("DisCon");  // デバイスが切り離されました(The device has been disconnected)
                            }
                        });
                    }
                    break;
                //-------------------------------------------------------------
                // Offset保存
                //-------------------------------------------------------------
                case STT_SVO :
                    sendCommand(CMD_SVO);  // Offset保存要請
                    result = mConnection.bulkTransfer(mEndpointIn, buffer, 64, 0);
                    //---------------------------------------------------------
                    // コマンド受信
                    //---------------------------------------------------------
                    if((result > 0)&&(buffer[0] == 'S')&&(buffer[1] == 'O')){
                        State = STT_STT;  // STATE = 計測開始
                        // メッセージ出力 -------------------------------------
                        handler.post(new Runnable(){
                            public void run(){
                                mess3.setText("Resume");  // 通信再開(Communication Resume)
                            }
                        });
                    }
                    //---------------------------------------------------------
                    // 正常応答でなければデバイスが切り離されたとしてスレッド終了
                    //---------------------------------------------------------
                    else{
                        mConnection.close();
                        ThFlag = 0;  // スレットループフラグクリア
                        // メッセージ出力 -------------------------------------
                        handler.post(new Runnable(){
                            public void run(){
                                mess3.setText("DisCon");  // デバイスが切り離されました(The device has been disconnected)
                            }
                        });
                    }
                    break;
                //-------------------------------------------------------------
                // Gain＆Offset受信
                //-------------------------------------------------------------
                case STT_RXG :
                    sendCommand(CMD_RXG);  // Gain＆Offset送信要請
                    result = mConnection.bulkTransfer(mEndpointIn, buffer, 64, 0);
                    //---------------------------------------------------------
                    // コマンド受信
                    //---------------------------------------------------------
                    if((result > 0)&&(buffer[0] == 'R')&&(buffer[1] == 'G')){
                        // Gain, Offset読み込み -------------------------------
                        // Flash保存は、unsigned intであるためTARGET側から送信時にデータ加工してある。
                        // Gain+ ----------------------------------------------
                        GainChAP[0] = (float )(buffer[3] *128+buffer[2]) /1000-10;  // CH1
                        GainChAP[1] = (float )(buffer[5] *128+buffer[4]) /1000-10;  // CH2
                        GainChAP[2] = (float )(buffer[7] *128+buffer[6]) /1000-10;  // CH3
                        GainChAP[3] = (float )(buffer[9] *128+buffer[8]) /1000-10;  // CH4
                        // Gain- ----------------------------------------------
                        GainChBP[0] = (float )(buffer[11]*128+buffer[10])/1000-10;  // CH1
                        GainChBP[1] = (float )(buffer[13]*128+buffer[12])/1000-10;  // CH2
                        GainChBP[2] = (float )(buffer[15]*128+buffer[14])/1000-10;  // CH3
                        GainChBP[3] = (float )(buffer[17]*128+buffer[16])/1000-10;  // CH4
                        // Offset ---------------------------------------------
                        OfstChP[0]  = (buffer[19]*128+buffer[18])-200;  // CH1
                        OfstChP[1]  = (buffer[21]*128+buffer[20])-200;  // CH2
                        OfstChP[2]  = (buffer[23]*128+buffer[22])-200;  // CH3
                        OfstChP[3]  = (buffer[25]*128+buffer[24])-200;  // CH4
                        //-----------------------------------------------------
                        State = STT_STT;  // STATE = 計測開始
                        // メッセージ出力 -------------------------------------
                        // メッセージ出力 -------------------------------------
                        handler.post(new Runnable(){
                            public void run(){
                                mess3.setText("Resume");  // 通信再開(Communication Resume)
                            }
                        });
                    }
                    //---------------------------------------------------------
                    // 正常応答でなければデバイスが切り離されたとしてスレッド終了
                    //---------------------------------------------------------
                    else{
                        mConnection.close();
                        ThFlag = 0;  // スレットループフラグクリア
                        // メッセージ出力 -------------------------------------
                        handler.post(new Runnable(){
                            public void run(){
                                mess3.setText("DisCon");  // デバイスが切り離されました(The device has been disconnected)
                            }
                        });
                    }
                    break;
                default:
                    State = STT_STT;  // STATE = 計測開始
                    break;
                }
        }
    }

    //=========================================================================
    // グラフを描画するクラス
    //-------------------------------------------------------------------------
    // 補足：グラフの起点は、左上です。
    // 範囲：(x,y)=(1000,700)
    //       オフセットx = 30
    //       オフセットy = 35
    //       =(30～1030, 35～735)
    // 中心：(x,y)=(500,350)
    //       オフセットx = 30
    //       オフセットy = 35
    //       =(530,385)
    //=========================================================================
    class MyView extends View{
        //---------------------------------------------------------------------
        // Viewの初期化
        //---------------------------------------------------------------------
        public MyView(Context context){
            super(context);
        }
        //---------------------------------------------------------------------
        // 描画実行メソッド
        //---------------------------------------------------------------------
        public void onDraw(Canvas canvas){
            int[][]      data   = new int[CH_MAX+MT_MAX][DataMax*2+50];  // データ          (CH1-CH4,MT+,MT-)
            int[][]      datag  = new int[CH_MAX+MT_MAX][DataMax  +50];  // グラフ描画データ(CH1-CH4,MT+,MT-)
            int[][]      datam  = new int[CH_MAX+MT_MAX][DataMax  +50];  // Measureデータ   (CH1-CH4,MT+,MT-)
            float        hsclDivTim;                  // ScaleH Div 時間
            String       hsclDivUnt;                  // ScaleH Div 単位
            String       hsclSmpSpd;                  // ScaleH Sampling 速度
            String[]     vsclName = new String[CH_MAX+MT_MAX];  // ScaleV Name(CH1-CH4,MT+,MT-)
            float        hsclGain;                    // ScaleH Gain
            float[]      vsclGain = new float [CH_MAX+MT_MAX];  // ScaleV Gain(CH1-CH4,MT+,MT-)
            float[]      vscl     = new float [CH_MAX+MT_MAX];  // ScaleV
            int[]        disp     = new int[CH_MAX+MT_MAX];     // CH表示     (CH1-CH4,MT+,MT-)
            float        dtIntv;                      // X軸描画間隔
            int          trgpos;                      // TRG検出位置(0=未検出)
            int          trgpstt;                     // TRG検出開始位置
            int          trglevel;                    // TRGレベル
            int          grpDtCnt;                    // グラフ描画データ数
            int          grpDtStNo;                   // グラフ描画開始データ番号
            int          grpDtStNoMax;                // グラフ描画開始データ番号最大
            final int    grpXmin = 30;                // グラフ描画 X最小
            final int    grpXmax = 1030;              // グラフ描画 X最大
            final int    grpYmin = 35;                // グラフ描画 Y最小
            final int    grpYmax = 735;               // グラフ描画 Y最小
            final int    grpXbas = 530;               // グラフ描画 X中心
            final int    grpYbas = 385;               // グラフ描画 Y中心
            float        x1,x2;                       // グラフデータx
            float        y1,y2;                       // グラフデータy
            float        smpus;                       // サンプリング間隔[us]
            float        smpxs;                       // サンプリング間隔[xs]
            int[]        ofstac = new int   [CH_MAX]; // Offset AC
            float[]      vave   = new float [CH_MAX]; // Vave
            float[]      vmax   = new float [CH_MAX]; // Vmax
            float[]      vmin   = new float [CH_MAX]; // Vmin
            float[]      vmid   = new float [CH_MAX]; // VmaxとVminの中間値
            int[]        epol   = new int   [CH_MAX]; // Edje Polarity(0=first edge+,1=first edge-)
            int[]        eps1   = new int   [CH_MAX]; // Edje Pos1
            int[]        eps2   = new int   [CH_MAX]; // Edje Pos2
            int[]        eps3   = new int   [CH_MAX]; // Edje Pos3
            float[]      peri   = new float [CH_MAX]; // Period[us]
            float[]      freq   = new float [CH_MAX]; // Frequency[kHz]
            float[]      wdtp   = new float [CH_MAX]; // Width+[us]
            float[]      wdtn   = new float [CH_MAX]; // Width-[us]
            float[]      duty   = new float [CH_MAX]; // Duty[%]
            final float  vinmax = 35;                 // 電圧入力範囲(-35V～35V)
            String[]     tmp    = new String[CH_MAX];
            int          dt;
            float        dtf;
            int          i;
            int          j;

            super.onDraw(canvas);
            Paint paintLn1 = new Paint();      // 枠線
            Paint paintLn2 = new Paint();      // 補助線
            Paint paintLn3 = new Paint();      // 中心線
            Paint paintCh1 = new Paint();      // CH1
            Paint paintCh2 = new Paint();      // CH2
            Paint paintCh3 = new Paint();      // CH3
            Paint paintCh4 = new Paint();      // CH4
            Paint paintCh5 = new Paint();      // MT+
            Paint paintCh6 = new Paint();      // MT-
            Paint paintTim = new Paint();      // Time
            Paint paintTrg = new Paint();      // TRGレベル
            Paint paintItm = new Paint();      // Item
            Paint paintMes = new Paint();      // Mesasureライン
            // 色 -------------------------------------------------------------
            canvas.drawColor(Color.BLACK);     // グラフ背景
            paintLn1.setColor(Color.WHITE);    // 枠線
            paintLn2.setColor(Color.DKGRAY);   // 補助線
            paintLn3.setColor(Color.WHITE);    // 中心線
            paintCh1.setColor(Color.YELLOW);   // CH1
            paintCh2.setColor(Color.GREEN);    // CH2
            paintCh3.setColor(Color.CYAN);     // CH3
            paintCh4.setColor(Color.MAGENTA);  // CH4
            paintCh5.setColor(Color.RED);      // MT+
            paintCh6.setColor(Color.BLUE);     // MT-
            paintTrg.setColor(Color.WHITE);    // TRGレベル
            paintItm.setColor(Color.WHITE);    // Item
            paintMes.setColor(Color.LTGRAY);   // Mesasureライン
            // 線幅 -----------------------------------------------------------
            paintLn1.setStrokeWidth(2);        // 枠線
            paintLn2.setStrokeWidth(1);        // 補助線
            paintLn3.setStrokeWidth(1);        // 中心線
            paintCh1.setStrokeWidth(1);        // CH1
            paintCh2.setStrokeWidth(1);        // CH2
            paintCh3.setStrokeWidth(1);        // CH3
            paintCh4.setStrokeWidth(1);        // CH4
            paintCh5.setStrokeWidth(1);        // MT+
            paintCh6.setStrokeWidth(1);        // MT-
            paintTrg.setStrokeWidth(1);        // TRGレベル
            paintItm.setStrokeWidth(1);        // Item
            paintMes.setStrokeWidth(1);        // Mesasureライン
            // 破線 -----------------------------------------------------------
            paintLn3.setPathEffect(new DashPathEffect(new float[]{ 10*ScaleX, 10*ScaleX }, 0));  // 中心線
            paintMes.setPathEffect(new DashPathEffect(new float[]{  5*ScaleY,  5*ScaleY }, 0));  // Mesasureライン
            // 文字サイズ -----------------------------------------------------
            paintCh1.setTextSize(25f*ScaleX);  // CH1
            paintCh2.setTextSize(25f*ScaleX);  // CH2
            paintCh3.setTextSize(25f*ScaleX);  // CH3
            paintCh4.setTextSize(25f*ScaleX);  // CH4
            paintCh5.setTextSize(25f*ScaleX);  // MT+
            paintCh6.setTextSize(25f*ScaleX);  // MT-
            paintItm.setTextSize(25f*ScaleX);  // Item

            //-----------------------------------------------------------------
            // ボタン表示をStopに変更(シーケンス内でのStop対応)
            //-----------------------------------------------------------------
            if(RunCnt==1){ button[4][1].setText("Stop"); }  // ボタン名変更

            //-----------------------------------------------------------------
            // グラフ枠の描画
            //-----------------------------------------------------------------
            // 補助線の描画 ---------------------------------------------------
            for(i=0; i<=10; i++){  // 縦軸 10本
                canvas.drawLine((grpXmin+i*100)*ScaleX, grpYmin*ScaleY, (grpXmin+i*100)*ScaleX, grpYmax*ScaleY, paintLn2);
            }
            for(i=0; i<7; i++){    // 横軸 7本(中心を0とする)
                canvas.drawLine(grpXmin*ScaleX, (85+i*100)*ScaleY, grpXmax*ScaleX, (grpYmin+i*100+50)*ScaleY, paintLn2);
            }
            // 中心線の描画 ---------------------------------------------------
            canvas.drawLine(grpXmin*ScaleX, grpYbas*ScaleY, grpXmax*ScaleX, grpYbas*ScaleY, paintLn3);  // 中心横
            canvas.drawLine(grpXbas*ScaleX, grpYmin*ScaleY, grpXbas*ScaleX, grpYmax*ScaleY, paintLn3);  // 中心縦
            // 枠線の描画 -----------------------------------------------------
            canvas.drawLine(grpXmin*ScaleX, grpYmin*ScaleY, grpXmin*ScaleX, grpYmax*ScaleY, paintLn1);  // 枠左
            canvas.drawLine(grpXmax*ScaleX, grpYmin*ScaleY, grpXmax*ScaleX, grpYmax*ScaleY, paintLn1);  // 枠右
            canvas.drawLine(grpXmin*ScaleX, grpYmin*ScaleY, grpXmax*ScaleX, grpYmin*ScaleY, paintLn1);  // 枠上
            canvas.drawLine(grpXmin*ScaleX, grpYmax*ScaleY, grpXmax*ScaleX, grpYmax*ScaleY, paintLn1);  // 枠下

            //-----------------------------------------------------------------
            // データの作成
            //-----------------------------------------------------------------
            // USB未接続時(ダミーデータ) --------------------------------------
            if(State==0){
                //RunCnt = 1;        // Stop
                HsclG    = Hscl;     // ScaleH (グラフ)
                TrgMdG   = TrgMd;    // TrgMode(グラフ)
                TrgChG   = TrgCh;    // TrgCH  (グラフ)
                TrgPosVG = TrgPosV;  // TrgPosV(グラフ)
                TrgPosHG = TrgPosH;  // TrgPosH(グラフ)
                for(i=0; i<CH_MAX; i++){
                    for(j=0; j<=DataMax*2; j++){
                        data[i][j] = DmyData[i][j];  // ダミーデータ
                    }
                }
            }
            // USB接続時(POS-4データ) -----------------------------------------
            else{
                // CH1-CH4(HOST Gain&Offset) ----------------------------------
                for(i=0; i<CH_MAX; i++){
                    for(j=0; j<=DataMax; j++){
                        dt = DataBff[i][j]+ OfstCh[i][Hscl];  // HOST Offset
                        if(dt>0){ data[i][j] = (int)(DataBff[i][j]*HrdGain*GainChA[i] + OfstCh[i][Hscl]); }  // HOST Gain+＆Offset
                        else    { data[i][j] = (int)(DataBff[i][j]*HrdGain*GainChB[i] + OfstCh[i][Hscl]); }  // HOST Gain-＆Offset
                    }
                }
            }
            //-----------------------------------------------------------------
            // 無効CHのデータを"0"にする。
            //-----------------------------------------------------------------
            // 4Msps ----------------------------------------------------------
            if(Hscl==0){
                for(i=0; i<=DataMax; i++){
                    data[1][i] = 0;  // CH2
                    data[2][i] = 0;  // CH3
                    data[3][i] = 0;  // CH4
                }
            }
            // 2Msps ----------------------------------------------------------
            if(Hscl==1){
                for(i=0; i<=DataMax; i++){
                    data[2][i] = 0;  // CH3
                    data[3][i] = 0;  // CH4
                }
            }
            //-----------------------------------------------------------------
            // AC計測のための処理(グラフデータ表示数最大)
            //-----------------------------------------------------------------
            for(j=0; j<CH_MAX; j++){  // CH1-CH4
                ofstac[j] = 0;
                // AC Offset値の算出 ------------------------------------------
                for(i=0; i<=DataMaxG; i++){
                    ofstac[j] += data[j][i];    // Sumup(for Average)
                }
                ofstac[j] = ofstac[j]/DataMaxG; // Average(AC Offset値)
                // AC計測のための減算 -----------------------------------------
                if(ChEn[j]==2){  // AC
                    for(i=0; i<DataMax; i++){
                        data[j][i] -= ofstac[j]; // ACデータ
                    }
                }
            }

            //-----------------------------------------------------------------
            // グラフZoomから各種設定の取得
            // 1.グラフ描画データ数
            // 2.グラフ描画開始データ番号最大
            // 3.ScaleH Gain
            //-----------------------------------------------------------------
            if(HsclG<2){
                if     (GrpZoomH==1){ grpDtCnt = 500; grpDtStNoMax = 0  ; hsclGain = 5F; }  // Zoom=1
                else if(GrpZoomH==2){ grpDtCnt = 200; grpDtStNoMax = 300; hsclGain = 2F; }  // Zoom=2
                else if(GrpZoomH==5){ grpDtCnt = 100; grpDtStNoMax = 400; hsclGain = 1F; }  // Zoom=5
                else                { grpDtCnt = 100; grpDtStNoMax = 400; hsclGain = 1F; }  // Zoom=5

            }
            else{
                if     (GrpZoomH==1){ grpDtCnt = 500; grpDtStNoMax = 0  ; hsclGain = 2F;   }  // Zoom=1
                else if(GrpZoomH==2){ grpDtCnt = 250; grpDtStNoMax = 250; hsclGain = 1F;   }  // Zoom=2
                else if(GrpZoomH==5){ grpDtCnt = 100; grpDtStNoMax = 400; hsclGain = 0.4F; }  // Zoom=5
                else                { grpDtCnt = 100; grpDtStNoMax = 400; hsclGain = 0.4F; }  // Zoom=5
            }
            if(GrpDtStNoLst>grpDtStNoMax){ GrpDtStNoLst = grpDtStNoMax;  }         // max処理
            canvas.drawText("Zx"+GrpZoomH, 40*ScaleX, (100-35)*ScaleY, paintItm);  // グラフZoom
            //-----------------------------------------------------------------
            // 時間レンジ(計測)
            // 有効CH：2.5us=CH1のみ有効
            //         5.0us=CH1,CH2のみ有効
            //-----------------------------------------------------------------
            for(i=0; i<CH_MAX+MT_MAX; i++){ disp[i] = ChEn[i]; } //  CH表示クリア
            hsclDivTim = 25F;
            hsclDivUnt = "";
            hsclSmpSpd = "";
            switch(Hscl){
                // 4Msps ------------------------------------------------------
                case 0:
                    hsclDivTim = 2.5F;
                    hsclDivUnt = "us";
                    hsclSmpSpd = "4Msps";
                    // CH表示 無効 --------------------------------------------
                    disp[1] = 0;  // CH2=OFF
                    disp[2] = 0;  // CH3=OFF
                    disp[3] = 0;  // CH4=OFF
                    disp[4] = 0;  // MT+=OFF
                    disp[5] = 0;  // MT-=OFF
                    break;
                // 2Msps ------------------------------------------------------
                case 1:
                    hsclDivTim = 5.0F;
                    hsclDivUnt = "us";
                    hsclSmpSpd = "2Msps";
                    // CH表示 無効 --------------------------------------------
                    disp[2] = 0;  // CH3=OFF
                    disp[3] = 0;  // CH4=OFF
                    break;
                // 1Msps ------------------------------------------------------
                case 2:
                    hsclDivTim = 25F;
                    hsclDivUnt = "us";
                    hsclSmpSpd = "1Msps";
                    break;
                // 500Ksps ----------------------------------------------------
                case 3:
                    hsclDivTim = 50F;
                    hsclDivUnt = "us";
                    hsclSmpSpd = "500Ksps";
                    break;
                // 250Ksps ----------------------------------------------------
                case 4:
                    hsclDivTim = 100F;
                    hsclDivUnt = "us";
                    hsclSmpSpd = "250Ksps";
                    break;
                // 100ksps ----------------------------------------------------
                case 5:
                    hsclDivTim = 250F;
                    hsclDivUnt = "us";
                    hsclSmpSpd = "100Ksps";
                    break;
                // 50Ksps -----------------------------------------------------
                case 6:
                    hsclDivTim = 500F;
                    hsclDivUnt = "us";
                    hsclSmpSpd = "50Ksps";
                    break;
                // 25Ksps -----------------------------------------------------
                case 7:
                    hsclDivTim = 1.0F;
                    hsclDivUnt = "ms";
                    hsclSmpSpd = "25Ksps";
                    break;
                // 10Ksps -----------------------------------------------------
                case 8:
                    hsclDivTim = 2.5F;
                    hsclDivUnt = "ms";
                    hsclSmpSpd = "10Ksps";
                    break;
                // 5Ksps ------------------------------------------------------
                case 9:
                    hsclDivTim = 5.0F;
                    hsclDivUnt = "ms";
                    hsclSmpSpd = "5Ksps";
                    break;
                // 2.5Ksps ----------------------------------------------------
                case 10:
                    hsclDivTim = 10F;
                    hsclDivUnt = "ms";
                    hsclSmpSpd = "2.5Ksps";
                    break;
                // 1Ksps ------------------------------------------------------
                case 11:
                    hsclDivTim = 25F;
                    hsclDivUnt = "ms";
                    hsclSmpSpd = "1Ksps";
                    break;
                // 500sps -----------------------------------------------------
                case 12:
                    hsclDivTim = 50F;
                    hsclDivUnt = "ms";
                    hsclSmpSpd = "500sps";
                    break;
                // 250sps -----------------------------------------------------
                case 13:
                    hsclDivTim = 100F;
                    hsclDivUnt = "ms";
                    hsclSmpSpd = "250sps";
                    break;
                default:
                    break;
            }
            // 時間レンジ表示 -------------------------------------------------
            if(hsclDivTim==(int)hsclDivTim){ tmp[0] = String.format("%.0f%s/ %s", hsclDivTim, hsclDivUnt, hsclSmpSpd); }  // 小数点無し
            else                           { tmp[0] = String.format("%.1f%s/ %s", hsclDivTim, hsclDivUnt, hsclSmpSpd); }  // 小数点下1桁
            canvas.drawText(tmp[0], (40+600)*ScaleX, (grpYmax-10)*ScaleY, paintItm);  // ScaleH Div(POS-4)
            //-----------------------------------------------------------------
            // 時間レンジ(グラフ)
            // dtIntv：X軸描画間隔(描画範囲 X=1000)
            //-----------------------------------------------------------------
            dtIntv= 4F;  // X軸描画間隔
            smpus = 1F;  // サンプリング間隔[us]
            smpxs = 1F;  // サンプリング間隔[xs]
            switch(HsclG){
                // 4Msps ------------------------------------------------------
                case 0:
                    dtIntv= 10F;  // X軸描画間隔
                    smpus = 0.25F;
                    smpxs = 0.25F;
                    hsclDivTim = 2.5F;
                    hsclDivUnt = "us";
                    break;
                // 2Msps ------------------------------------------------------
                case 1:
                    dtIntv= 10F;  // X軸描画間隔
                    smpus = 0.5F;
                    smpxs = 0.5F;
                    hsclDivTim = 5.0F;
                    hsclDivUnt = "us";
                    break;
                // 1Msps ------------------------------------------------------
                case 2:
                    smpus = 1F;
                    smpxs = 1F;
                    hsclDivTim = 25F;
                    hsclDivUnt = "us";
                    break;
                // 500Ksps ----------------------------------------------------
                case 3:
                    smpus = 2F;
                    smpxs = 2F;
                    hsclDivTim = 50F;
                    hsclDivUnt = "us";
                    break;
                // 250Ksps ----------------------------------------------------
                case 4:
                    smpus = 4F;
                    smpxs = 4F;
                    hsclDivTim = 100F;
                    hsclDivUnt = "us";
                    break;
                // 100Ksps ----------------------------------------------------
                case 5:
                    smpus = 10F;
                    smpxs = 10F;
                    hsclDivTim = 250F;
                    hsclDivUnt = "us";
                    break;
                // 50Ksps -----------------------------------------------------
                case 6:
                    smpus = 20F;
                    smpxs = 20F;
                    hsclDivTim = 500F;
                    hsclDivUnt = "us";
                    break;
                // 25Ksps -----------------------------------------------------
                case 7:
                    smpus = 40F;
                    smpxs = 0.04F;
                    hsclDivTim = 1.0F;
                    hsclDivUnt = "ms";
                    break;
                // 10Ksps -----------------------------------------------------
                case 8:
                    smpus = 100F;
                    smpxs = 0.1F;
                    hsclDivTim = 2.5F;
                    hsclDivUnt = "ms";
                    break;
                // 5Ksps ------------------------------------------------------
                case 9:
                    smpus = 200F;
                    smpxs = 0.2F;
                    hsclDivTim = 5.0F;
                    hsclDivUnt = "ms";
                    break;
                // 2.5Ksps ----------------------------------------------------
                case 10:
                    smpus = 400F;
                    smpxs = 0.4F;
                    hsclDivTim = 10F;
                    hsclDivUnt = "ms";
                    break;
                // 1Ksps ------------------------------------------------------
                case 11:
                    smpus = 1000F;
                    smpxs = 1F;
                    hsclDivTim = 25F;
                    hsclDivUnt = "ms";
                    break;
                // 500sps -----------------------------------------------------
                case 12:
                    smpus = 2000F;
                    smpxs = 2F;
                    hsclDivTim = 50F;
                    hsclDivUnt = "ms";
                    break;
                // 250sps -----------------------------------------------------
                case 13:
                    smpus = 4000F;
                    smpxs = 4F;
                    hsclDivTim = 100F;
                    hsclDivUnt = "ms";
                    break;
                default:
                    break;
            }
            dtIntv = dtIntv/hsclGain;  // X軸描画間隔(ScaleH Gain)
            // 時間レンジ表示 -------------------------------------------------
            dt = (int)(hsclDivTim*hsclGain);
            if(hsclDivTim*hsclGain==dt){ tmp[0] = String.format("Disp:%.0f%s/", hsclDivTim*hsclGain, hsclDivUnt); }  // 小数点無し
            else                       { tmp[0] = String.format("Disp:%.1f%s/", hsclDivTim*hsclGain, hsclDivUnt); }  // 小数点下1桁
            canvas.drawText(tmp[0], (40+600)*ScaleX, (grpYmax-40)*ScaleY, paintItm);  // ScaleH Div(グラフ)
            //-----------------------------------------------------------------
            // 電圧レンジ(計測)
            // 12bitデータを描画範囲(Y=0～700)に変更
            //-----------------------------------------------------------------
            for(i=0; i<CH_MAX+MT_MAX; i++){
                switch(VsclCh[i]){
                    case 0:
                        vsclName[i] = "200mV/";
                        vscl[i]     = 50F;
                        break;
                    case 1:
                        vsclName[i] = "500mV/";
                        vscl[i]     = 20F;
                        break;
                    case 2:
                        vsclName[i] = " 1.0V/";
                        vscl[i]     = 10F;
                        break;
                    case 3:
                        vsclName[i] = " 2.0V/";
                        vscl[i]     = 5F;
                        break;
                    case 4:
                        vsclName[i] = " 5.0V/";
                        vscl[i]     = 2F;
                        break;
                    case 5:
                        vsclName[i] = "10.0V/";
                        vscl[i]     = 1F;
                        break;
                    case 6:
                        vsclName[i] = "20.0V/";
                        vscl[i]     = 0.5F;
                        break;
                    case 7:
                        vsclName[i] = "50.0V/";
                        vscl[i]     = 0.2F;
                        break;
                    default:
                        vsclName[i] = "200mV/";
                        vscl[i]     = 50F;
                        break;
                }
                vsclGain[i] = vscl[i]*700/4095;  //  12bitデータを描画範囲(Y=0～700)に変更
            }
            for(i=0; i<CH_MAX; i++){  // CH1-CH4
                if(ChEn[i]==2){ vsclName[i] = '*' + vsclName[i]; }  // AC計測='*'を付加
            }
            if(disp[0]!=0){ canvas.drawText(vsclName[0], (40    )*ScaleX, (grpYmax-10)*ScaleY, paintCh1); }  // CH1
            if(disp[1]!=0){ canvas.drawText(vsclName[1], (40+100)*ScaleX, (grpYmax-10)*ScaleY, paintCh2); }  // CH2
            if(disp[2]!=0){ canvas.drawText(vsclName[2], (40+200)*ScaleX, (grpYmax-10)*ScaleY, paintCh3); }  // CH3
            if(disp[3]!=0){ canvas.drawText(vsclName[3], (40+300)*ScaleX, (grpYmax-10)*ScaleY, paintCh4); }  // CH4
            if(disp[4]!=0){ canvas.drawText(vsclName[4], (40+400)*ScaleX, (grpYmax-10)*ScaleY, paintCh5); }  // MT+
            if(disp[5]!=0){ canvas.drawText(vsclName[5], (40+500)*ScaleX, (grpYmax-10)*ScaleY, paintCh6); }  // MT-

            //-----------------------------------------------------------------
            // Drag操作
            //-----------------------------------------------------------------
            // DragScaleH(グラフ描画開始番号) ---------------------------------
            dt = GrpDtStNoLst - (int)(DrgMvSclH/dtIntv);           // Drag値を減算
            if     (dt<0)           { grpDtStNo = 0; }             // min処理
            else if(dt>grpDtStNoMax){ grpDtStNo = grpDtStNoMax; }  // max処理
            else                    { grpDtStNo = dt; }
            GrpDtStNo = grpDtStNo;                                 // グラフ描画開始データ番号
            // DragBase/DragTrg -----------------------------------------------
            if(DrgSel==0){
                // DragBase ---------------------------------------------------
                for(i=0; i<CH_MAX+MT_MAX; i++){
                    if(ChEn[i]!=0){                           // 無効：EnableCH=OFF
                        dt = BaseChLst[i] - DrgMvBsC[i];      // Drag値を減算
                        if     (dt> 300){ BaseCh[i] = 300; }  // max処理
                        else if(dt<-300){ BaseCh[i] =-300; }  // min処理
                        else            { BaseCh[i] =  dt; }
                    }
                }
                // DragTrg ----------------------------------------------------
                if((Mode!=0)&&(ChEn[TrgCh]!=2)){  // 無効(MODE=Auto,TrgCh=AC)
                    // TrgPosV ------------------------------------------------
                    dt = TrgPosVLst - (int)(DrgMvTrgV/vsclGain[TrgCh]);  // Drag値を減算
                    if     (dt> 2040){ TrgPosV = 2040; }                 // max処理
                    else if(dt<-2040){ TrgPosV =-2040; }                 // min処理
                    else             { TrgPosV =   dt; }
                    // TrgPosH ------------------------------------------------
                    dt = TrgPosHLst + (int)(DrgMvTrgH/dtIntv);  // Drag値を加算
                    if     (dt>495){ TrgPosH = 495; }           // max処理
                    else if(dt<  5){ TrgPosH =   5; }           // min処理
                    else           { TrgPosH =  dt; }
                }
            }
            // ボタン対応 -----------------------------------------------------
            else{
                for(i=0; i<CH_MAX+MT_MAX; i++){ BaseCh[i] = BaseChLst[i]; }  // DragBase
                TrgPosV = TrgPosVLst;                            // DragTrgV
                TrgPosH = TrgPosHLst;                            // DragTrgH
            }
            // DragMesXY ------------------------------------------------------
            if(DrgSel==1){
                // MesX1 ------------------------------------------------------
                dt = MesPosX1Lst + (int)(DrgMvMsX1/dtIntv);  // Drag値を加算
                if     (dt>500){ MesPosX1 = 500; }           // max処理
                else if(dt<  0){ MesPosX1 =   0; }           // min処理
                else           { MesPosX1 =  dt; }
                // MesX2 ------------------------------------------------------
                dt = MesPosX2Lst + (int)(DrgMvMsX2/dtIntv);  // Drag値を加算
                if     (dt>500){ MesPosX2 = 500; }           // max処理
                else if(dt<  0){ MesPosX2 =   0; }           // min処理
                else           { MesPosX2 =  dt; }
                // MesY1 ------------------------------------------------------
                dt = MesPosY1Lst - (int)(DrgMvMsY1/vsclGain[ChSel]);  // Drag値を減算
                if     (dt> 2040){ MesPosY1 = 2048; }                 // max処理
                else if(dt<-2040){ MesPosY1 =-2048; }                 // min処理
                else             { MesPosY1 =   dt; }
                // MesY2 ------------------------------------------------------
                dt = MesPosY2Lst - (int)(DrgMvMsY2/vsclGain[ChSel]);  // Drag値を減算
                if     (dt> 2040){ MesPosY2 = 2048; }                 // max処理
                else if(dt<-2040){ MesPosY2 =-2048; }                 // min処理
                else             { MesPosY2 =   dt; }
            }

            //-----------------------------------------------------------------
            // TrgPosV検出
            // 無効：MODE=Auto,TrgCh=AC
            //-----------------------------------------------------------------
            trgpstt = 0;  // TRG検出開始位置クリア
            trgpos  = 0;  // TRG検出位置クリア
            if((Mode!=0)&&(ChEn[TrgCh]!=2)){  // 無効(MODE=Auto,TrgCh=AC)
                trgpstt  = TrgPosHG;       // TRG検出開始位置
                trglevel = (int)TrgPosVG;  // TRGレベル
                for(i=trgpstt; i<=DataMax; i++){
                    // Rise ---------------------------------------------------
                    if(TrgMd == 0){
                        if((data[TrgCh][i]>=trglevel) && (data[TrgCh][i-1]<=trglevel)){
                            trgpos = i;  // TRG検出位置
                            break;
                        }
                    }
                    // Fall ---------------------------------------------------
                    else{
                        if((data[TrgCh][i]<=trglevel) && (data[TrgCh][i-1]>=trglevel)){
                            trgpos = i;  // TRG検出位置
                            break;
                        }
                    }
                }
                // メッセージ表示 ---------------------------------------------
                if(TrgFind==0)   { canvas.drawText("Trg'?(T="+TrgTimo+"s)", (40+800)*ScaleX, (grpYmax-10)*ScaleY, paintItm); }  // Trg'?
                if(TrgFind==1)   {
                    if(trgpos!=0){ canvas.drawText("Trg'd"  , (40+800)*ScaleX, (grpYmax-10)*ScaleY, paintItm); }                // Trg'd
                    else         { canvas.drawText("Trg'not", (40+800)*ScaleX, (grpYmax-10)*ScaleY, paintItm); trgpstt = 0; }   // Trg'not(設計上ありえない(DEBUG用))
                }
                if(TrgFind==2)   { canvas.drawText("Timeout "+TrgTimo+"s",  (40+800)*ScaleX, (grpYmax-10)*ScaleY, paintItm); trgpstt = 0; trgpos  = 0;}  // TrgTimeout
                if(TrgFind==3)   { canvas.drawText("Trg'?(T="+TrgTimo+"s)", (40+800)*ScaleX, (grpYmax-10)*ScaleY, paintItm); trgpstt = 0; trgpos  = 0;}  // Trg'?(前回Timeout)
            }
            //-----------------------------------------------------------------
            // グラフ描画データの作成(TRG検出位置の適応)
            //-----------------------------------------------------------------
            if((State==0)&&(trgpos==0)){ trgpstt = 0; }  // USB未接続時
            for(i=0; i<CH_MAX; i++){
                for(j=0; j<=DataMax; j++){
                    dt = (trgpos-trgpstt) + j;  // TRG検出位置の適応
                    if(dt<0){ dt = 0; }         // min処理
                    // max処理 ------------------------------------------------
                    if(State==0){ if(dt>DataMax*2){ dt = DataMax*2; } }  // USB未接続時(ダミーデータ)
                    else        { if(dt>DataMax  ){ dt = DataMax;   } }  // USB接続時  (POS-4データ)
                    datag[i][j] = data[i][dt];       // グラフ描画データ
                }
            }
            // MT+,MT- --------------------------------------------------------
            for(i=0; i<=DataMax; i++){
                datag[4][i] = datag[MathP1][i] + datag[MathP2][i];  // MT+
                datag[5][i] = datag[MathN1][i] - datag[MathN2][i];  // MT-
            }
            //-----------------------------------------------------------------
            // TRGラインの描画
            // 無効：MODE=Auto,TrgCh=AC
            //-----------------------------------------------------------------
            if((Mode!=0)&&(ChEn[TrgCh]!=2)){  // 無効(MODE=Auto,TrgCh=AC)
                // TrgPosH ----------------------------------------------------
                dt = (int)((TrgPosH-GrpDtStNo)*dtIntv);
                if(dt<   0){ dt = 0;    }  // min処理
                if(dt>1000){ dt = 1000; }  // max処理
                canvas.drawText("T", (22+dt)*ScaleX, 27*ScaleY, paintItm);  // TrgPosH目盛
                canvas.drawLine((grpXmin+dt)*ScaleX, grpYmin*ScaleY, (grpXmin+dt)*ScaleX, grpYmax*ScaleY, paintTrg);  // TrgPosHライン
                // TrgPosV ----------------------------------------------------
                canvas.drawText("T"+String.valueOf(TrgCh+1), (grpXmax-30)*ScaleX, (grpYbas+8-TrgPosV*vsclGain[TrgCh]-BaseCh[TrgCh])*ScaleY, paintItm);  // TrgPosV目盛
                canvas.drawLine(grpXmin*ScaleX, (grpYbas-TrgPosV*vsclGain[TrgCh]-BaseCh[TrgCh])*ScaleY,
                                    grpXmax*ScaleX, (grpYbas-TrgPosV*vsclGain[TrgCh]-BaseCh[TrgCh])*ScaleY, paintTrg);    // TrgPosVライン
            }
            //-----------------------------------------------------------------
            // Measureラインの描画
            //-----------------------------------------------------------------
            if(DrgSel==1){
                // MesX1 ------------------------------------------------------
                dt = (int)((MesPosX1-GrpDtStNo)*dtIntv);
                if(dt<   0){ dt = 0;    }  // min処理
                if(dt>1000){ dt = 1000; }  // max処理
                canvas.drawText("X1", (22+dt)*ScaleX, 27*ScaleY, paintItm);                                           // MesY1目盛
                canvas.drawLine((grpXmin+dt)*ScaleX, grpYmin*ScaleY, (grpXmin+dt)*ScaleX, grpYmax*ScaleY, paintMes);  // MesX1ライン
                // MesX2 ------------------------------------------------------
                dt = (int)((MesPosX2-GrpDtStNo)*dtIntv);
                if(dt<   0){ dt = 0;    }  // min処理
                if(dt>1000){ dt = 1000; }  // max処理
                canvas.drawText("X2", (22+dt)*ScaleX, 27*ScaleY, paintItm);                                           // MesY2目盛
                canvas.drawLine((grpXmin+dt)*ScaleX, grpYmin*ScaleY, (grpXmin+dt)*ScaleX, grpYmax*ScaleY, paintMes);  // MesX2ライン
                // MesY1 ------------------------------------------------------
                canvas.drawText("Y1", (grpXmax-30)*ScaleX, (grpYbas+8-MesPosY1*vsclGain[ChSel]-BaseCh[ChSel])*ScaleY, paintItm);  // MesY1目盛
                canvas.drawLine(grpXmin*ScaleX, (grpYbas-MesPosY1*vsclGain[ChSel]-BaseCh[ChSel])*ScaleY,
                                grpXmax*ScaleX, (grpYbas-MesPosY1*vsclGain[ChSel]-BaseCh[ChSel])*ScaleY, paintMes);               // MesY1ライン
                // MesY2 ------------------------------------------------------
                canvas.drawText("Y2", (grpXmax-30)*ScaleX, (grpYbas+8-MesPosY2*vsclGain[ChSel]-BaseCh[ChSel])*ScaleY, paintItm);  // MesY2目盛
                canvas.drawLine(grpXmin*ScaleX, (grpYbas-MesPosY2*vsclGain[ChSel]-BaseCh[ChSel])*ScaleY,
                                grpXmax*ScaleX, (grpYbas-MesPosY2*vsclGain[ChSel]-BaseCh[ChSel])*ScaleY, paintMes);               // MesY2ライン
            }
            //-----------------------------------------------------------------
            // Base目盛の表示
            //-----------------------------------------------------------------
            if(disp[0]!=0){ canvas.drawText("Ch1", grpXmin*ScaleX, (grpYbas+8-BaseCh[0])*ScaleY, paintCh1); }  // CH1
            if(disp[1]!=0){ canvas.drawText("Ch2", grpXmin*ScaleX, (grpYbas+8-BaseCh[1])*ScaleY, paintCh2); }  // CH2
            if(disp[2]!=0){ canvas.drawText("Ch3", grpXmin*ScaleX, (grpYbas+8-BaseCh[2])*ScaleY, paintCh3); }  // CH3
            if(disp[3]!=0){ canvas.drawText("Ch4", grpXmin*ScaleX, (grpYbas+8-BaseCh[3])*ScaleY, paintCh4); }  // CH4
            if(disp[4]!=0){ canvas.drawText("Mt+", grpXmin*ScaleX, (grpYbas+8-BaseCh[4])*ScaleY, paintCh5); }  // MT+
            if(disp[5]!=0){ canvas.drawText("Mt-", grpXmin*ScaleX, (grpYbas+8-BaseCh[5])*ScaleY, paintCh6); }  // MT-

            //-----------------------------------------------------------------
            // グラフ描画開始番号の表示
            //-----------------------------------------------------------------
            tmp[0] = String.format("%.2f", grpDtStNo*smpxs);                              // 小数点下2桁
            dtf = Float.parseFloat(tmp[0]);
            if     (dtf    ==(int)dtf)      { tmp[0] = String.format("%.0f", dtf); }      // 小数点無し
            else if(dtf*10F==(int)(dtf*10F)){ tmp[0] = String.format("%.1f", dtf); }      // 小数点1桁
            canvas.drawText("H:"+tmp[0]+hsclDivUnt+"("+grpDtStNo+")", (40+50)*ScaleX, (100-35)*ScaleY, paintItm);  // グラフ描画開始データ番号＆PosH
            //-----------------------------------------------------------------
            // TRGライン値の表示
            //-----------------------------------------------------------------
            if((Mode!=0)&&(ChEn[TrgCh]!=2)){  // 無効(MODE=Auto,TrgCh=AC)
                // TrgPosV ----------------------------------------------------
                tmp[0] = String.format("TV:%.2fV(%d)", TrgPosV/2048F*vinmax, TrgPosV);    // TrgPosV 小数点下2桁[V]
                canvas.drawText(tmp[0], 40*ScaleX, (130-35)*ScaleY, paintItm);            // TrgPosV
                // TrgPosH ----------------------------------------------------
                tmp[0] = String.format("%.2f", TrgPosH*smpxs);                            // 小数点下2桁
                dtf = Float.parseFloat(tmp[0]);
                if     (dtf    ==(int)dtf)      { tmp[0] = String.format("%.0f", dtf); }  // 小数点無し
                else if(dtf*10F==(int)(dtf*10F)){ tmp[0] = String.format("%.1f", dtf); }  // 小数点1桁
                canvas.drawText("TH:"+tmp[0]+hsclDivUnt+"("+TrgPosH+")", (40+215)*ScaleX, (130-35)*ScaleY, paintItm);  // TrgPosH
            }
            //-----------------------------------------------------------------
            // TrgCh=AC時の注意メッセージ
            //-----------------------------------------------------------------
            if((Mode!=0)&&(ChEn[TrgCh]==2)){  // MODE!=Auto,TrgCh=AC
                canvas.drawText("TRG can not be used in AC measure.", 40*ScaleX, (grpYmax-160)*ScaleY, paintItm);  // TRGは、AC測定には使用できません。
            }
            //-----------------------------------------------------------------
            // Measureライン値の表示
            //-----------------------------------------------------------------
            if(DrgSel==1){
                // MesX1 ------------------------------------------------------
                tmp[0] = String.format("%.2f", MesPosX1*smpxs);                           // 小数点下2桁
                dtf = Float.parseFloat(tmp[0]);
                if     (dtf    ==(int)dtf)      { tmp[0] = String.format("%.0f", dtf); }  // 小数点無し
                else if(dtf*10F==(int)(dtf*10F)){ tmp[0] = String.format("%.1f", dtf); }  // 小数点1桁
                canvas.drawText("X1:"+tmp[0]+hsclDivUnt+"("+MesPosX1+")", 40*ScaleX, (160-35)*ScaleY, paintItm);  // MesPosX1
                // MesX2 ------------------------------------------------------
                tmp[0] = String.format("%.2f", MesPosX2*smpxs);                           // 小数点下2桁
                dtf = Float.parseFloat(tmp[0]);
                if     (dtf    ==(int)dtf)      { tmp[0] = String.format("%.0f", dtf); }  // 小数点無し
                else if(dtf*10F==(int)(dtf*10F)){ tmp[0] = String.format("%.1f", dtf); }  // 小数点1桁
                canvas.drawText("X2:"+tmp[0]+hsclDivUnt+"("+MesPosX2+")", 40*ScaleX, (190-35)*ScaleY, paintItm);  // MesPosX2
                // MesY1 ------------------------------------------------------
                tmp[0] = String.format("Y1:%.2fV(%d)", MesPosY1/2048F*vinmax, MesPosY1);  // MesPosY1 小数点下2桁[V]
                canvas.drawText(tmp[0], (40+215)*ScaleX, (160-35)*ScaleY, paintItm);      // MesPosY1
                // MesY2 ------------------------------------------------------
                tmp[0] = String.format("Y2:%.2fV(%d)", MesPosY2/2048F*vinmax, MesPosY2);  // MesPosY2 小数点下2桁[V]
                canvas.drawText(tmp[0], (40+215)*ScaleX, (190-35)*ScaleY, paintItm);      // MesPosY2
                // MesX2-X1 ---------------------------------------------------
                dt = MesPosX2-MesPosX1;                                                   // MesPosX2-X1
                tmp[0] = String.format("%.2f", dt*smpxs);                                 // 小数点下2桁
                dtf = Float.parseFloat(tmp[0]);
                if     (dtf    ==(int)dtf)      { tmp[0] = String.format("%.0f", dtf); }  // 小数点無し
                else if(dtf*10F==(int)(dtf*10F)){ tmp[0] = String.format("%.1f", dtf); }  // 小数点1桁
                canvas.drawText("dX:"+tmp[0]+hsclDivUnt+"("+dt+")", 40*ScaleX, (220-35)*ScaleY, paintItm);  // MesdX
                // MesY2-Y1 ---------------------------------------------------
                dt = MesPosY2-MesPosY1;                                                   // MesPosY2-Y1
                tmp[0] = String.format("dY:%.2fV(%d)", dt/2048F*vinmax, dt);              // Mes dY 小数点下2桁[V]
                canvas.drawText(tmp[0], (40+215)*ScaleX, (220-35)*ScaleY, paintItm);      // Mes dY
            }

            //-----------------------------------------------------------------
            // データの描画
            //-----------------------------------------------------------------
            for(i=0; i<grpDtCnt; i++){
                x1 =     i*dtIntv + grpXmin;
                x2 = (i+1)*dtIntv + grpXmin;
                // max処理＆min処理 -------------------------------------------
                if(x1<grpXmin){ x1 = grpXmin; }
                if(x2<grpXmin){ x2 = grpXmin; }
                if(x1>grpXmax){ x1 = grpXmax; }
                if(x2>grpXmax){ x2 = grpXmax; }
                // モニタサイズに合わせる
                x1 = x1 * ScaleX;
                x2 = x2 * ScaleX;
                for(j=0; j<CH_MAX+MT_MAX; j++){  // CH1-CH4,MT+,MT-
                    y1 = (int)((grpYbas-BaseCh[j]) - datag[j][GrpDtStNo+i  ]*vsclGain[j]);
                    y2 = (int)((grpYbas-BaseCh[j]) - datag[j][GrpDtStNo+i+1]*vsclGain[j]);
                    // max処理＆min処理 ---------------------------------------
                    if(y1<grpYmin){ y1 = grpYmin; }
                    if(y2<grpYmin){ y2 = grpYmin; }
                    if(y1>grpYmax){ y1 = grpYmax; }
                    if(y2>grpYmax){ y2 = grpYmax; }
                    // モニタサイズに合わせる
                    y1 = y1 * ScaleY;
                    y2 = y2 * ScaleY;
                    // 描画 ---------------------------------------------------
                    if((j==0) && (disp[0]!=0)){ canvas.drawLine(x1,y1,x2,y2, paintCh1); }  // CH1
                    if((j==1) && (disp[1]!=0)){ canvas.drawLine(x1,y1,x2,y2, paintCh2); }  // CH2
                    if((j==2) && (disp[2]!=0)){ canvas.drawLine(x1,y1,x2,y2, paintCh3); }  // CH3
                    if((j==3) && (disp[3]!=0)){ canvas.drawLine(x1,y1,x2,y2, paintCh4); }  // CH4
                    if((j==4) && (disp[4]!=0)){ canvas.drawLine(x1,y1,x2,y2, paintCh5); }  // MT+
                    if((j==5) && (disp[5]!=0)){ canvas.drawLine(x1,y1,x2,y2, paintCh6); }  // MT-
                }
            }
            //-----------------------------------------------------------------
            // Offset値の表示(HOST&POS-4)
            //-----------------------------------------------------------------
            // HOST -----------------------------------------------------------
            if(AdjOfstDisp==1){
                // Title表示 --------------------------------------------------
                canvas.drawText("Hscl", (40+500)*ScaleX, (100-35)*ScaleY, paintItm);  // Hscl番号
                canvas.drawText("Ch1" , (40+600)*ScaleX, (100-35)*ScaleY, paintCh1);  // CH1
                canvas.drawText("Ch2" , (40+700)*ScaleX, (100-35)*ScaleY, paintCh2);  // CH2
                canvas.drawText("Ch3" , (40+800)*ScaleX, (100-35)*ScaleY, paintCh3);  // CH3
                canvas.drawText("Ch4" , (40+900)*ScaleX, (100-35)*ScaleY, paintCh4);  // CH4
                // データ表示 -------------------------------------------------
                for(i=0; i<HSCL_MAX; i++){
                    canvas.drawText("Hscl"+i                    , (40+500)*ScaleX, (100+35*i)*ScaleY, paintItm);  // Hscl番号
                    canvas.drawText(String.valueOf(OfstCh[0][i]), (40+600)*ScaleX, (100+35*i)*ScaleY, paintCh1);  // CH1
                    canvas.drawText(String.valueOf(OfstCh[1][i]), (40+700)*ScaleX, (100+35*i)*ScaleY, paintCh2);  // CH2
                    canvas.drawText(String.valueOf(OfstCh[2][i]), (40+800)*ScaleX, (100+35*i)*ScaleY, paintCh3);  // CH3
                    canvas.drawText(String.valueOf(OfstCh[3][i]), (40+900)*ScaleX, (100+35*i)*ScaleY, paintCh4);  // CH4
                }
                // Average算出のための合計 ------------------------------------
                for(i=0; i<CH_MAX; i++){ OfstChA[i]=0; }  // Sumupのためクリア
                for(i=0; i<CH_MAX; i++){
                    for(j=0; j<HSCL_MAX; j++){ OfstChA[i] += OfstCh[i][j]; }  // Sumup(for Average)
                }
                // Average(使用していないレンジを除く) ------------------------
                OfstChA[0] = OfstChA[0]/14;  // CH1
                OfstChA[1] = OfstChA[1]/13;  // CH2
                OfstChA[2] = OfstChA[2]/12;  // CH3
                OfstChA[3] = OfstChA[3]/12;  // CH4
                // Average表示 ------------------------------------------------
                canvas.drawText("Ave."                    , (40+500)*ScaleX, (100+35*14)*ScaleY, paintItm);  // Ave.
                canvas.drawText(String.valueOf(OfstChA[0]), (40+600)*ScaleX, (100+35*14)*ScaleY, paintCh1);  // CH1
                canvas.drawText(String.valueOf(OfstChA[1]), (40+700)*ScaleX, (100+35*14)*ScaleY, paintCh2);  // CH2
                canvas.drawText(String.valueOf(OfstChA[2]), (40+800)*ScaleX, (100+35*14)*ScaleY, paintCh3);  // CH3
                canvas.drawText(String.valueOf(OfstChA[3]), (40+900)*ScaleX, (100+35*14)*ScaleY, paintCh4);  // CH4
            }
            // POS-4 ----------------------------------------------------------
            if(AdjGainDisp==2){
                canvas.drawText(String.valueOf(OfstChP[0]), (40    )*ScaleX, (grpYmax-130)*ScaleY, paintCh1);  // CH1
                canvas.drawText(String.valueOf(OfstChP[1]), (40+100)*ScaleX, (grpYmax-130)*ScaleY, paintCh2);  // CH2
                canvas.drawText(String.valueOf(OfstChP[2]), (40+200)*ScaleX, (grpYmax-130)*ScaleY, paintCh3);  // CH3
                canvas.drawText(String.valueOf(OfstChP[3]), (40+300)*ScaleX, (grpYmax-130)*ScaleY, paintCh4);  // CH4
                canvas.drawText("Offset"                  , (40+400)*ScaleX, (grpYmax-130)*ScaleY, paintItm);  // Item
            }
            //-----------------------------------------------------------------
            // Gain値の表示(HOST,POS-4)
            //-----------------------------------------------------------------
            if(AdjGainDisp!=0){
                // Gain+ ------------------------------------------------------
                for(i=0; i<CH_MAX; i++){
                    if(AdjGainDisp==1){ tmp[i] = String.format("%.3f",GainChA[i]);  }  // HOST  小数点下3桁
                    if(AdjGainDisp==2){ tmp[i] = String.format("%.3f",GainChAP[i]); }  // POS-4 小数点下3桁
                }
                canvas.drawText(tmp[0], (40    )*ScaleX, (grpYmax-100)*ScaleY, paintCh1);  // CH1
                canvas.drawText(tmp[1], (40+100)*ScaleX, (grpYmax-100)*ScaleY, paintCh2);  // CH2
                canvas.drawText(tmp[2], (40+200)*ScaleX, (grpYmax-100)*ScaleY, paintCh3);  // CH3
                canvas.drawText(tmp[3], (40+300)*ScaleX, (grpYmax-100)*ScaleY, paintCh4);  // CH4
                canvas.drawText("Gain+",(40+400)*ScaleX, (grpYmax-100)*ScaleY, paintItm);  // Item
                // Gain- ------------------------------------------------------
                for(i=0; i<CH_MAX; i++){
                    if(AdjGainDisp==1){ tmp[i] = String.format("%.3f",GainChB[i]);  }  // HOST  小数点下3桁
                    if(AdjGainDisp==2){ tmp[i] = String.format("%.3f",GainChBP[i]); }  // POS-4 小数点下3桁
                }
                canvas.drawText(tmp[0], (40    )*ScaleX, (grpYmax-70)*ScaleY, paintCh1);  // CH1
                canvas.drawText(tmp[1], (40+100)*ScaleX, (grpYmax-70)*ScaleY, paintCh2);  // CH2
                canvas.drawText(tmp[2], (40+200)*ScaleX, (grpYmax-70)*ScaleY, paintCh3);  // CH3
                canvas.drawText(tmp[3], (40+300)*ScaleX, (grpYmax-70)*ScaleY, paintCh4);  // CH4
                canvas.drawText("Gain-",(40+400)*ScaleX, (grpYmax-70)*ScaleY, paintItm);  // Item
            }
            //-----------------------------------------------------------------
            // 平均電圧値の表示(12bit(-2047=-35V,0=0V,+2048=35V)
            //-----------------------------------------------------------------
            for(j=0; j<CH_MAX; j++){  // CH1-CH4
                vave[j] = 0;
                for(i=GrpDtStNo; i<(GrpDtStNo+grpDtCnt); i++){ vave[j] += datag[j][i]; } // Sumup(for Average)
                vave[j] = vave[j] / grpDtCnt;                    // Average
                if(vave[j]>0){ vave[j] = vave[j]/2048*vinmax; }  // 0～+2048→0～+35V
                else         { vave[j] = vave[j]/2048*vinmax; }  // 0～-2047→0～-35V
            }
            // 表示 -----------------------------------------------------------
            for(i=0; i<CH_MAX; i++){ tmp[i] = String.format("%.2fV", vave[i]); }  // 小数点下2桁
            if(disp[0]!=0){ canvas.drawText(tmp[0], (40    )*ScaleX, (grpYmax-40)*ScaleY, paintCh1); }  // CH1
            if(disp[1]!=0){ canvas.drawText(tmp[1], (40+100)*ScaleX, (grpYmax-40)*ScaleY, paintCh2); }  // CH2
            if(disp[2]!=0){ canvas.drawText(tmp[2], (40+200)*ScaleX, (grpYmax-40)*ScaleY, paintCh3); }  // CH3
            if(disp[3]!=0){ canvas.drawText(tmp[3], (40+300)*ScaleX, (grpYmax-40)*ScaleY, paintCh4); }  // CH4
            //-----------------------------------------------------------------
            // Measure値の表示(Vave,Vmax,Vmin)
            // グラフ表示範囲内
            //-----------------------------------------------------------------
            if(MeasureDisp==1){
                for(j=0; j<CH_MAX; j++){  // CH1-CH4
                    vave[j] = 0;
                    vmax[j] = -2048;
                    vmin[j] =  2048;
                    vmid[j] = 0;
                    epol[j] = 0;
                    eps1[j] = 0;
                    eps2[j] = 0;
                    eps3[j] = 0;
                    peri[j] = 0;
                    freq[j] = 0;
                    wdtp[j] = 0;
                    wdtn[j] = 0;
                    duty[j] = 0;
                    //---------------------------------------------------------
                    // AC Offsetを無効にする。
                    //---------------------------------------------------------
                    for(i=0; i<=DataMaxG; i++){
                        if(ChEn[j]==2){ datam[j][i] = datag[j][i] + ofstac[j]; }  // AC計測
                        else          { datam[j][i] = datag[j][i]; }              // DC計測
                    }
                    //---------------------------------------------------------
                    // max,min,aveの検出
                    //---------------------------------------------------------
                    for(i=GrpDtStNo; i<(GrpDtStNo+grpDtCnt); i++){
                        dt  = datam[j][i];               // DC
                        // max,min,ave ----------------------------------------
                        if(dt>vmax[j]){ vmax[j] = dt; }  // Vmax
                        if(dt<vmin[j]){ vmin[j] = dt; }  // Vmin
                        vave[j] += dt;                   // Sumup(for Vave)
                    }
                    vave[j] = vave[j] / grpDtCnt;   // Vave
                    //---------------------------------------------------------
                    // Pulseの検出
                    // epol=0：__|~~|__|~~, // epol=1：~~|__|~~|__
                    //---------------------------------------------------------
                    vmid[j] = (vmax[j]-vmin[j])/2F+vmin[j] ;  // maxとminの中間値
                    for(i=GrpDtStNo; i<(GrpDtStNo+grpDtCnt); i++){
                        if(eps1[j]==0){
                            if((datam[j][i+1]>=vmid[j]) && (datam[j][i]<=vmid[j])){ eps1[j]=i+1; epol[j] = 0; }  // Rise
                            if((datam[j][i+1]<=vmid[j]) && (datam[j][i]>=vmid[j])){ eps1[j]=i+1; epol[j] = 1; }  // Fall
                        }else if(eps2[j]==0){
                            if  (epol[j]==0){ if(datam[j][i+1]<=vmid[j]) { eps2[j]=i+1; } }  // Fall
                            else            { if(datam[j][i+1]>=vmid[j]) { eps2[j]=i+1; } }  // Rise
                        }else if(eps3[j]==0){
                            if  (epol[j]==0){ if(datam[j][i+1]>=vmid[j]) { eps3[j]=i+1; } }  // Rise
                            else            { if(datam[j][i+1]<=vmid[j]) { eps3[j]=i+1; } }  // Fall
                        }
                    }
                    //---------------------------------------------------------
                    // Measure値の算出
                    // 0～+2048→0～+35V
                    //---------------------------------------------------------
                    vave[j] = vave[j]/2048*vinmax;  // Vave
                    vmax[j] = vmax[j]/2048*vinmax;  // Vmax
                    vmin[j] = vmin[j]/2048*vinmax;  // Vmin
                    if(eps3[j]!=0){ peri[j] = (eps3[j]-eps1[j])*smpus; }       // Peri [us]
                    if(eps3[j]!=0){ freq[j] = 1F/peri[j]*1000; }               // Freq [kHz]
                    if(eps2[j]!=0){
                        if(epol[j]==0){ wdtp[j] = (eps2[j]-eps1[j])*smpus; }   // Wdth+[us]
                        else          { wdtn[j] = (eps2[j]-eps1[j])*smpus; }   // Wdth-[us]
                    }
                    if(eps3[j]!=0){
                        if(epol[j]==0){ wdtn[j] = (eps3[j]-eps2[j])*smpus; }   // wdth-[us]
                        else          { wdtp[j] = (eps3[j]-eps2[j])*smpus; }   // wdth+[us]
                    }
                    if(eps3[j]!=0){ duty[j] = wdtp[j]/(wdtp[j]+wdtn[j])*100; } // Duty [%]
                }

                //-------------------------------------------------------------
                // データ表示
                //-------------------------------------------------------------
                // Title ------------------------------------------------------
                canvas.drawText("Item", 450*ScaleX, (100-35)*ScaleY, paintItm);  // Item
                canvas.drawText("Ch1" , 540*ScaleX, (100-35)*ScaleY, paintCh1);  // CH1
                canvas.drawText("Ch2" , 665*ScaleX, (100-35)*ScaleY, paintCh2);  // CH2
                canvas.drawText("Ch3" , 790*ScaleX, (100-35)*ScaleY, paintCh3);  // CH3
                canvas.drawText("Ch4" , 915*ScaleX, (100-35)*ScaleY, paintCh4);  // CH4
                // Vave -------------------------------------------------------
                for(i=0; i<CH_MAX; i++){ tmp[i] = String.format("%.2fV", vave[i]); }                      // 小数点下2桁[V]
                canvas.drawText("Vave",                 450*ScaleX, (100+35*0)*ScaleY, paintItm);    // Vave
                if(disp[0]!=0){ canvas.drawText(tmp[0], 540*ScaleX, (100+35*0)*ScaleY, paintCh1); }  // CH1
                if(disp[1]!=0){ canvas.drawText(tmp[1], 665*ScaleX, (100+35*0)*ScaleY, paintCh2); }  // CH2
                if(disp[2]!=0){ canvas.drawText(tmp[2], 790*ScaleX, (100+35*0)*ScaleY, paintCh3); }  // CH3
                if(disp[3]!=0){ canvas.drawText(tmp[3], 915*ScaleX, (100+35*0)*ScaleY, paintCh4); }  // CH4
                // Vmax -------------------------------------------------------
                for(i=0; i<CH_MAX; i++){ tmp[i] = String.format("%.2fV", vmax[i]); }                      // 小数点下2桁[V]
                canvas.drawText("Vmax",                 450*ScaleX, (100+35*1)*ScaleY, paintItm);    // Vmax
                if(disp[0]!=0){ canvas.drawText(tmp[0], 540*ScaleX, (100+35*1)*ScaleY, paintCh1); }  // CH1
                if(disp[1]!=0){ canvas.drawText(tmp[1], 665*ScaleX, (100+35*1)*ScaleY, paintCh2); }  // CH2
                if(disp[2]!=0){ canvas.drawText(tmp[2], 790*ScaleX, (100+35*1)*ScaleY, paintCh3); }  // CH3
                if(disp[3]!=0){ canvas.drawText(tmp[3], 915*ScaleX, (100+35*1)*ScaleY, paintCh4); }  // CH4
                // Vmin -------------------------------------------------------
                for(i=0; i<CH_MAX; i++){ tmp[i] = String.format("%.2fV", vmin[i]); }                      // 小数点下2桁[V]
                canvas.drawText("Vmin",                 450*ScaleX, (100+35*2)*ScaleY, paintItm);    // Vmin
                if(disp[0]!=0){ canvas.drawText(tmp[0], 540*ScaleX, (100+35*2)*ScaleY, paintCh1); }  // CH1
                if(disp[1]!=0){ canvas.drawText(tmp[1], 665*ScaleX, (100+35*2)*ScaleY, paintCh2); }  // CH2
                if(disp[2]!=0){ canvas.drawText(tmp[2], 790*ScaleX, (100+35*2)*ScaleY, paintCh3); }  // CH3
                if(disp[3]!=0){ canvas.drawText(tmp[3], 915*ScaleX, (100+35*2)*ScaleY, paintCh4); }  // CH4
                // Vpp --------------------------------------------------------
                for(i=0; i<CH_MAX; i++){ tmp[i] = String.format("%.2fV", vmax[i]-vmin[i]); }              // 小数点下2桁[V]
                canvas.drawText("Vpp",                  450*ScaleX, (100+35*3)*ScaleY, paintItm);    // Vpp
                if(disp[0]!=0){ canvas.drawText(tmp[0], 540*ScaleX, (100+35*3)*ScaleY, paintCh1); }  // CH1
                if(disp[1]!=0){ canvas.drawText(tmp[1], 665*ScaleX, (100+35*3)*ScaleY, paintCh2); }  // CH2
                if(disp[2]!=0){ canvas.drawText(tmp[2], 790*ScaleX, (100+35*3)*ScaleY, paintCh3); }  // CH3
                if(disp[3]!=0){ canvas.drawText(tmp[3], 915*ScaleX, (100+35*3)*ScaleY, paintCh4); }  // CH4
                // Freq -------------------------------------------------------
                for(i=0; i<CH_MAX; i++){
                    if(freq[i]<1){ tmp[i] = String.format("%.2fHz" , freq[i]*1000); }                // 小数点下2桁[Hz]
                    else         { tmp[i] = String.format("%.2fkHz", freq[i]); }                     // 小数点下2桁[kHz]
                }
                canvas.drawText("Freq",                 450*ScaleX, (100+35*4)*ScaleY, paintItm);    // Freq
                if(disp[0]!=0){ canvas.drawText(tmp[0], 540*ScaleX, (100+35*4)*ScaleY, paintCh1); }  // CH1
                if(disp[1]!=0){ canvas.drawText(tmp[1], 665*ScaleX, (100+35*4)*ScaleY, paintCh2); }  // CH2
                if(disp[2]!=0){ canvas.drawText(tmp[2], 790*ScaleX, (100+35*4)*ScaleY, paintCh3); }  // CH3
                if(disp[3]!=0){ canvas.drawText(tmp[3], 915*ScaleX, (100+35*4)*ScaleY, paintCh4); }  // CH4
                // Peri -------------------------------------------------------
                for(i=0; i<CH_MAX; i++){
                    if(peri[i]>=1000){ tmp[i] = String.format("%.2fms", peri[i]/1000); }             // 小数点下2桁[ms]
                    else             { tmp[i] = String.format("%.1fus", peri[i]); }                  // 小数点下1桁[us]
                }
                canvas.drawText("Peri",                 450*ScaleX, (100+35*5)*ScaleY, paintItm);    // Peri
                if(disp[0]!=0){ canvas.drawText(tmp[0], 540*ScaleX, (100+35*5)*ScaleY, paintCh1); }  // CH1
                if(disp[1]!=0){ canvas.drawText(tmp[1], 665*ScaleX, (100+35*5)*ScaleY, paintCh2); }  // CH2
                if(disp[2]!=0){ canvas.drawText(tmp[2], 790*ScaleX, (100+35*5)*ScaleY, paintCh3); }  // CH3
                if(disp[3]!=0){ canvas.drawText(tmp[3], 915*ScaleX, (100+35*5)*ScaleY, paintCh4); }  // CH4
                // Duty -------------------------------------------------------
                for(i=0; i<CH_MAX; i++){ tmp[i] = String.format("%.1f%%", duty[i]); }                     // 小数点下1桁[%]
                canvas.drawText("Duty",                 450*ScaleX, (100+35*6)*ScaleY, paintItm);    // Duty
                if(disp[0]!=0){ canvas.drawText(tmp[0], 540*ScaleX, (100+35*6)*ScaleY, paintCh1); }  // CH1
                if(disp[1]!=0){ canvas.drawText(tmp[1], 665*ScaleX, (100+35*6)*ScaleY, paintCh2); }  // CH2
                if(disp[2]!=0){ canvas.drawText(tmp[2], 790*ScaleX, (100+35*6)*ScaleY, paintCh3); }  // CH3
                if(disp[3]!=0){ canvas.drawText(tmp[3], 915*ScaleX, (100+35*6)*ScaleY, paintCh4); }  // CH4
                // Wdt+ -------------------------------------------------------
                for(i=0; i<CH_MAX; i++){
                    if(wdtp[i]>=1000){ tmp[i] = String.format("%.2fms", wdtp[i]/1000); }             // 小数点下2桁[ms]
                    else             { tmp[i] = String.format("%.1fus", wdtp[i]); }                  // 小数点下1桁[us]
                }
                canvas.drawText("Wdt+",                 450*ScaleX, (100+35*7)*ScaleY, paintItm);    // Wdt+
                if(disp[0]!=0){ canvas.drawText(tmp[0], 540*ScaleX, (100+35*7)*ScaleY, paintCh1); }  // CH1
                if(disp[1]!=0){ canvas.drawText(tmp[1], 665*ScaleX, (100+35*7)*ScaleY, paintCh2); }  // CH2
                if(disp[2]!=0){ canvas.drawText(tmp[2], 790*ScaleX, (100+35*7)*ScaleY, paintCh3); }  // CH3
                if(disp[3]!=0){ canvas.drawText(tmp[3], 915*ScaleX, (100+35*7)*ScaleY, paintCh4); }  // CH4
                // Wdt- -------------------------------------------------------
                for(i=0; i<CH_MAX; i++){
                    if(wdtn[i]>=1000){ tmp[i] = String.format("%.2fms", wdtn[i]/1000); }             // 小数点下2桁[ms]
                    else             { tmp[i] = String.format("%.1fus", wdtn[i]); }                  // 小数点下1桁[us]
                }
                canvas.drawText("Wdt-",                 450*ScaleX, (100+35*8)*ScaleY, paintItm);    // Wdt-
                if(disp[0]!=0){ canvas.drawText(tmp[0], 540*ScaleX, (100+35*8)*ScaleY, paintCh1); }  // CH1
                if(disp[1]!=0){ canvas.drawText(tmp[1], 665*ScaleX, (100+35*8)*ScaleY, paintCh2); }  // CH2
                if(disp[2]!=0){ canvas.drawText(tmp[2], 790*ScaleX, (100+35*8)*ScaleY, paintCh3); }  // CH3
                if(disp[3]!=0){ canvas.drawText(tmp[3], 915*ScaleX, (100+35*8)*ScaleY, paintCh4); }  // CH4
                if(disp[3]!=0){ canvas.drawText(tmp[3], 915*ScaleX, (100+35*8)*ScaleY, paintCh4); }  // CH4

                //-------------------------------------------------------------
                // Measure十字線の描画
                //-------------------------------------------------------------
                paintCh1.setStrokeWidth(2);  // CH1
                paintCh2.setStrokeWidth(2);  // CH2
                paintCh3.setStrokeWidth(2);  // CH3
                paintCh4.setStrokeWidth(2);  // CH4
                for(i=0; i<CH_MAX; i++){  // CH1-CH4
                    for(j=0; j<3; j++){  // Edje Pos1-3
                        if(j==0){ dt = eps1[i];} // Edje Pos1
                        if(j==1){ dt = eps2[i];} // Edje Pos2
                        if(j==2){ dt = eps3[i];} // Edje Pos3
                        x1 = (dt-GrpDtStNo)*dtIntv + grpXmin;
                        y1 = (int)((grpYbas-BaseCh[i]) - datag[i][dt]*vsclGain[i]);
                        // 描画(＋) -------------------------------------------
                        if((i==0)&&(disp[0]!=0)){ canvas.drawLine((x1-10)*ScaleX, y1    *ScaleY,(x1+10)*ScaleX, y1    *ScaleY, paintCh1);  // CH1
                                                  canvas.drawLine( x1    *ScaleX,(y1-10)*ScaleY, x1    *ScaleX,(y1+10)*ScaleY, paintCh1);
                        }
                        if((i==1)&&(disp[1]!=0)){ canvas.drawLine((x1-10)*ScaleX, y1    *ScaleY,(x1+10)*ScaleX, y1    *ScaleY, paintCh2);  // CH2
                                                  canvas.drawLine( x1    *ScaleX,(y1-10)*ScaleY, x1    *ScaleX,(y1+10)*ScaleY, paintCh2);
                        }
                        if((i==2)&&(disp[2]!=0)){ canvas.drawLine((x1-10)*ScaleX, y1    *ScaleY,(x1+10)*ScaleX, y1    *ScaleY, paintCh3);  // CH3
                                                  canvas.drawLine( x1    *ScaleX,(y1-10)*ScaleY, x1    *ScaleX,(y1+10)*ScaleY, paintCh3);
                        }
                        if((i==3)&&(disp[3]!=0)){ canvas.drawLine((x1-10)*ScaleX, y1    *ScaleY,(x1+10)*ScaleX, y1    *ScaleY, paintCh4);  // CH4
                                                  canvas.drawLine( x1    *ScaleX,(y1-10)*ScaleY, x1    *ScaleX,(y1+10)*ScaleY, paintCh4);
                        }
                    }
                }
                //-------------------------------------------------------------
                // VmaxとVminの中間線の描画
                //-------------------------------------------------------------
                paintCh1.setStrokeWidth(1);  // CH1
                paintCh2.setStrokeWidth(1);  // CH2
                paintCh3.setStrokeWidth(1);  // CH3
                paintCh4.setStrokeWidth(1);  // CH4
                paintCh1.setPathEffect(new DashPathEffect(new float[]{ 15*ScaleX, 15*ScaleX }, 0));  // CH1
                paintCh2.setPathEffect(new DashPathEffect(new float[]{ 15*ScaleX, 15*ScaleX }, 0));  // CH2
                paintCh3.setPathEffect(new DashPathEffect(new float[]{ 15*ScaleX, 15*ScaleX }, 0));  // CH3
                paintCh4.setPathEffect(new DashPathEffect(new float[]{ 15*ScaleX, 15*ScaleX }, 0));  // CH4
                for(i=0; i<CH_MAX; i++){  // CH1-CH4
                    y1 = (int)((grpYbas-BaseCh[i]) - vmid[i]*vsclGain[i]);  // Average(Offset値)
                    if((i==0)&&(disp[0]!=0)){ canvas.drawLine(grpXmin*ScaleX, y1*ScaleY, grpXmax*ScaleX, y1*ScaleY, paintCh1); }  // CH1
                    if((i==1)&&(disp[1]!=0)){ canvas.drawLine(grpXmin*ScaleX, y1*ScaleY, grpXmax*ScaleX, y1*ScaleY, paintCh2); }  // CH2
                    if((i==2)&&(disp[2]!=0)){ canvas.drawLine(grpXmin*ScaleX, y1*ScaleY, grpXmax*ScaleX, y1*ScaleY, paintCh3); }  // CH3
                    if((i==3)&&(disp[3]!=0)){ canvas.drawLine(grpXmin*ScaleX, y1*ScaleY, grpXmax*ScaleX, y1*ScaleY, paintCh4); }  // CH4
                }
            }

            //-----------------------------------------------------------------
            // Touch Areaの描画
            //-----------------------------------------------------------------
            x1 = 0;
            x2 = 0;
            y1 = 0;
            y2 = 0;
            paintItm.setStyle(Paint.Style.STROKE);  // 線で矩形を描く
            switch(TouchGuide){
                // ScaleH -----------------------------------------------------
                case 1:
                    x1 = (30+   0+5)*ScaleX;
                    x2 = (30+1000-5)*ScaleX;
                    y1 = (35+ 550+5)*ScaleY;
                    y2 = (35+ 700-5)*ScaleY;
                    break;
                // BaseCH1 ----------------------------------------------------
                case 2:
                    x1 = (30+  0+5)*ScaleX;
                    x2 = (30+100-5)*ScaleX;
                    y1 = (35+  0+5)*ScaleY;
                    y2 = (35+700-5)*ScaleY;
                    break;
                // BaseCH2 ----------------------------------------------------
                case 3:
                    x1 = (30+100+5)*ScaleX;
                    x2 = (30+200-5)*ScaleX;
                    y1 = (35+  0+5)*ScaleY;
                    y2 = (35+700-5)*ScaleY;
                    break;
                // BaseCH3 ----------------------------------------------------
                case 4:
                    x1 = (30+200+5)*ScaleX;
                    x2 = (30+300-5)*ScaleX;
                    y1 = (35+  0+5)*ScaleY;
                    y2 = (35+700-5)*ScaleY;
                    break;
                // BaseCH4 ----------------------------------------------------
                case 5:
                    x1 = (30+300+5)*ScaleX;
                    x2 = (30+400-5)*ScaleX;
                    y1 = (35+  0+5)*ScaleY;
                    y2 = (35+700-5)*ScaleY;
                    break;
                // BaseMT+ ----------------------------------------------------
                case 6:
                    x1 = (30+400+5)*ScaleX;
                    x2 = (30+500-5)*ScaleX;
                    y1 = (35+  0+5)*ScaleY;
                    y2 = (35+700-5)*ScaleY;
                    break;
                // BaseMT- ----------------------------------------------------
                case 7:
                    x1 = (30+500+5)*ScaleX;
                    x2 = (30+600-5)*ScaleX;
                    y1 = (35+  0+5)*ScaleY;
                    y2 = (35+700-5)*ScaleY;
                    break;
                // TrgV -------------------------------------------------------
                case 8:
                    if(Mode!=0){
                        x1 = (30+600+5)*ScaleX;
                        x2 = (30+800-5)*ScaleX;
                        y1 = (35+  0+5)*ScaleY;
                        y2 = (35+700-5)*ScaleY;
                    }
                    break;
                 // TrgH ------------------------------------------------------
                case 9:
                    if(Mode!=0){
                        x1 = (30+   0+5)*ScaleX;
                        x2 = (30+1000-5)*ScaleX;
                        y1 = (35+   0+5)*ScaleY;
                        y2 = (35+ 150-5)*ScaleY;
                    }
                    break;
                // MesX1 ------------------------------------------------------
                case 10:
                    x1 = (30+   0+5)*ScaleX;
                    x2 = (30+1000-5)*ScaleX;
                    y1 = (35+   0+5)*ScaleY;
                    y2 = (35+ 250-5)*ScaleY;
                    break;
                // MesX2 ------------------------------------------------------
                case 11:
                    x1 = (30+   0+5)*ScaleX;
                    x2 = (30+1000-5)*ScaleX;
                    y1 = (35+ 250+5)*ScaleY;
                    y2 = (35+ 550-5)*ScaleY;
                    break;
                // MesY1 ------------------------------------------------------
                case 12:
                    x1 = (30+600+5)*ScaleX;
                    x2 = (30+700-5)*ScaleX;
                    y1 = (35+  0+5)*ScaleY;
                    y2 = (35+700-5)*ScaleY;
                    break;
                // MesY2 ------------------------------------------------------
                case 13:
                    x1 = (30+700+5)*ScaleX;
                    x2 = (30+800-5)*ScaleX;
                    y1 = (35+  0+5)*ScaleY;
                    y2 = (35+700-5)*ScaleY;
                    break;
                // Zoom -------------------------------------------------------
                case 14:
                    x1 = (30+ 800+5)*ScaleX;
                    x2 = (30+1000-5)*ScaleX;
                    y1 = (35+   0+5)*ScaleY;
                    y2 = (35+ 700-5)*ScaleY;
                    break;
                default:
                    break;
            }
            //canvas.drawRoundRect(x1,y1,x2,y2,10*ScaleX,10*ScaleY, paintItm);  // TouchGuideの描画(Android 5.0以上にて対応)
            canvas.drawRect(x1,y1,x2,y2, paintItm);  // TouchGuideの描画
        }
    }
}
